<?php

/**
 * The plugin bootstrap file
 *
 * This file is read by WordPress to generate the plugin information in the plugin
 * admin area. This file also includes all of the dependencies used by the plugin,
 * registers the activation and deactivation functions, and defines a function
 * that starts the plugin.
 *
 * @since             1.0.0
 * @package           PLUGIN_NAME
 *
 * @wordpress-plugin
 * Plugin Name:       EDGE Database
 * Description:       Add and update new entries to the EDGE Database.
 */

// If this file is called directly, abort.
if (!defined('WPINC')) {
	die;
}

function my_admin_menu()
{
	add_menu_page(
		__('DB Entries', 'my-textdomain'),
		__('EDGE Database', 'my-textdomain'),
		'read',
		'db-entries',
		'edge_db_page_contents',
		'dashicons-schedule',
		3
	);
}
add_action('admin_menu', 'my_admin_menu');

function remove_menues()
{
	remove_menu_page('index.php');
	remove_menu_page('profile.php');
	remove_menu_page('edit.php');
	remove_menu_page('edit.php?post_type=page');
	remove_menu_page('upload.php');
	remove_menu_page('edit-comments.php');
	remove_menu_page('themes.php');
	remove_menu_page('tools.php');
	remove_menu_page('options-general.php');
}
add_action('admin_menu', 'remove_menues');

function redirect_dashboard($redirect_to)
{
	return admin_url('admin.php?page=db-entries');
}
add_filter('login_redirect', 'redirect_dashboard', 10, 1);

function insert_records_callback()
{
	global $wpdb;

	$entry = $_POST['entry'];
	$entry_name = $entry[0];
	$entry_list = $entry[1];

	if ($entry_name == 'pilots') {
		$db_inserted = $wpdb->insert(
			'edge_pilot_program',
			array(
				'CompanyName' => $entry_list['CompanyName'],
				'ProjectNumber' => $entry_list['ProjectNumber'],
				'ProjectType' => $entry_list['ProjectType'],
				'PilotType' => $entry_list['PilotType'],
				'PilotStatus' => $entry_list['PilotStatus'],
				'NewConstruction' => $entry_list['NewConstruction'],
				'ProjectDescription' => $entry_list['ProjectDescription'],
				'PilotTerm' => $entry_list['PilotTerm'],
				'ProjectedTaxesAbatedCity' => $entry_list['ProjectedTaxesAbatedCity'],
				'ProjectedTaxesAbatedCityPercent' => $entry_list['ProjectedTaxesAbatedCityPercent'],
				'ProjectedTaxesAbatedCounty' => $entry_list['ProjectedTaxesAbatedCounty'],
				'ProjectedTaxesAbatedCountyPercent' => $entry_list['ProjectedTaxesAbatedCountyPercent'],
				'DateApproved' => $entry_list['DateApproved'],
				'DateClosedRealProperty' => $entry_list['DateClosedRealProperty'],
				'DateClosedPersonalProperty' => $entry_list['DateClosedPersonalProperty'],
				'DateClosedEffectiveDate' => $entry_list['DateClosedEffectiveDate'],
				'LeaseBeginsRealProperty' => $entry_list['LeaseBeginsRealProperty'],
				'LeaseBeginsPersonalProperty' => $entry_list['LeaseBeginsPersonalProperty'],
				'LeaseExpiresRealProperty' => $entry_list['LeaseExpiresRealProperty'],
				'LeaseExpiresPersonalProperty' => $entry_list['LeaseExpiresPersonalProperty'],
				'DateAmended01' => $entry_list['DateAmended01'],
				'DateAmended02' => $entry_list['DateAmended02'],
				'DateAmended03' => $entry_list['DateAmended03'],
				'DateAmended04' => $entry_list['DateAmended04'],
				'DateAmended05' => $entry_list['DateAmended05'],
				'RampUpPeriod' => $entry_list['RampUpPeriod'],
				'ProjectedNewJobs' => $entry_list['ProjectedNewJobs'],
				'ProjectedAveragePayrollOfNewJobs' => $entry_list['ProjectedAveragePayrollOfNewJobs'],
				'TotalNewPayroll' => $entry_list['TotalNewPayroll'],
				'ProjectedRetainedJobs' => $entry_list['ProjectedRetainedJobs'],
				'ProjectedAveragePayrollOfRetainedJobs' => $entry_list['ProjectedAveragePayrollOfRetainedJobs'],
				'TotalRetainedPayroll' => $entry_list['TotalRetainedPayroll'],
				'TotalJobs' => $entry_list['TotalJobs'],
				'EmploymentDirect' => $entry_list['EmploymentDirect'],
				'EmploymentIndirect' => $entry_list['EmploymentIndirect'],
				'WagesDirect' => $entry_list['WagesDirect'],
				'WagesIndirect' => $entry_list['WagesIndirect'],
				'ProjectedCapitalInvestment' => $entry_list['ProjectedCapitalInvestment'],
				'RealPropertyInvestment' => $entry_list['RealPropertyInvestment'],
				'PersonalPropertyInvestment' => $entry_list['PersonalPropertyInvestment'],
				'CommunityReinvestmentCredit' => $entry_list['CommunityReinvestmentCredit'],
				'CapitalInvestmentNotInPilot' => $entry_list['CapitalInvestmentNotInPilot'],
				'ProjectedMWBE_LOSBSpending' => $entry_list['ProjectedMWBE_LOSBSpending'],
				'MWBE_LOSBSpendingConstruction' => $entry_list['MWBE_LOSBSpendingConstruction'],
				'MWBE_LOSBSpendingOperations' => $entry_list['MWBE_LOSBSpendingOperations'],
				'TotalCapitalInvestment' => $entry_list['TotalCapitalInvestment'],
				'TotalIncentiveProvided' => $entry_list['TotalIncentiveProvided'],
				'TotalNewTaxRevenues' => $entry_list['TotalNewTaxRevenues'],
				'BenefitCostRatio' => $entry_list['BenefitCostRatio'],
				'ParcelID' => $entry_list['ParcelID'],
				'CityCouncilDistrict' => $entry_list['CityCouncilDistrict'],
				'CountyCommissionDistrict' => $entry_list['CountyCommissionDistrict'],
				'TotalRealPropertyTaxesBefore' => $entry_list['TotalRealPropertyTaxesBefore'],
				'TotalPersonalPropertyTaxesBefore' => $entry_list['TotalPersonalPropertyTaxesBefore'],
				'TotalRealPropertyTaxesDuring' => $entry_list['TotalRealPropertyTaxesDuring'],
				'TotalPersonalPropertyTaxesDuring' => $entry_list['TotalPersonalPropertyTaxesDuring'],
				'TotalRealPropertyTaxesAfter' => $entry_list['TotalRealPropertyTaxesAfter'],
				'TotalPersonalPropertyTaxesAfter' => $entry_list['TotalPersonalPropertyTaxesAfter'],
				'logo' => $entry_list['logo'],
				'VideoThumbnail' => $entry_list['VideoThumbnail'],
				'VideoURL' => $entry_list['VideoURL'],
				'ProjectLocation' => $entry_list['ProjectLocation'],
				'Lat' => $entry_list['Lat'],
				'Lng' => $entry_list['Lng'],
				'Address' => $entry_list['Address'],
				'Address2' => $entry_list['Address2'],
				'City' => $entry_list['City'],
				'State' => $entry_list['State'],
				'ZipCode' => $entry_list['ZipCode'],
				'Address02_Lat' => $entry_list['Address02_Lat'],
				'Address02_Lng' => $entry_list['Address02_Lng'],
				'Address02_Address' => $entry_list['Address02_Address'],
				'Address02_Address2' => $entry_list['Address02_Address2'],
				'Address02_City' => $entry_list['Address02_City'],
				'Address02_State' => $entry_list['Address02_State'],
				'Address02_ZipCode' => $entry_list['Address02_ZipCode'],
				'Address03_Lat' => $entry_list['Address03_Lat'],
				'Address03_Lng' => $entry_list['Address03_Lng'],
				'Address03_Address' => $entry_list['Address03_Address'],
				'Address03_Address2' => $entry_list['Address03_Address2'],
				'Address03_City' => $entry_list['Address03_City'],
				'Address03_State' => $entry_list['Address03_State'],
				'Address03_ZipCode' => $entry_list['Address03_ZipCode'],
				'Address04_Lat' => $entry_list['Address04_Lat'],
				'Address04_Lng' => $entry_list['Address04_Lng'],
				'Address04_Address' => $entry_list['Address04_Address'],
				'Address04_Address2' => $entry_list['Address04_Address2'],
				'Address04_City' => $entry_list['Address04_City'],
				'Address04_State' => $entry_list['Address04_State'],
				'Address04_ZipCode' => $entry_list['Address04_ZipCode'],
				'Address05_Lat' => $entry_list['Address05_Lat'],
				'Address05_Lng' => $entry_list['Address05_Lng'],
				'Address05_Address' => $entry_list['Address05_Address'],
				'Address05_Address2' => $entry_list['Address05_Address2'],
				'Address05_City' => $entry_list['Address05_City'],
				'Address05_State' => $entry_list['Address05_State'],
				'Address05_ZipCode' => $entry_list['Address05_ZipCode'],
				'Address06_Lat' => $entry_list['Address06_Lat'],
				'Address06_Lng' => $entry_list['Address06_Lng'],
				'Address06_Address' => $entry_list['Address06_Address'],
				'Address06_Address2' => $entry_list['Address06_Address2'],
				'Address06_City' => $entry_list['Address06_City'],
				'Address06_State' => $entry_list['Address06_State'],
				'Address06_ZipCode' => $entry_list['Address06_ZipCode'],
				'Address07_Lat' => $entry_list['Address07_Lat'],
				'Address07_Lng' => $entry_list['Address07_Lng'],
				'Address07_Address' => $entry_list['Address07_Address'],
				'Address07_Address2' => $entry_list['Address07_Address2'],
				'Address07_City' => $entry_list['Address07_City'],
				'Address07_State' => $entry_list['Address07_State'],
				'Address07_ZipCode' => $entry_list['Address07_ZipCode'],
				'Address08_Lat' => $entry_list['Address08_Lat'],
				'Address08_Lng' => $entry_list['Address08_Lng'],
				'Address08_Address' => $entry_list['Address08_Address'],
				'Address08_Address2' => $entry_list['Address08_Address2'],
				'Address08_City' => $entry_list['Address08_City'],
				'Address08_State' => $entry_list['Address08_State'],
				'Address08_ZipCode' => $entry_list['Address08_ZipCode'],
				'total_square_footage' => $entry_list['total_square_footage'],
				'number_of_apartment_units' => $entry_list['number_of_apartment_units'],
				'incentive_approved' => $entry_list['incentive_approved'],
				'date_closed' => $entry_list['date_closed'],
				'lease_begins' => $entry_list['lease_begins'],
				'lease_expires' => $entry_list['lease_expires'],
				'avg_payroll_projected_retained' => $entry_list['avg_payroll_projected_retained'],
				'FileLink' => $entry_list['FileLink'],
			)
		);
	} else if ($entry_name == 'tifs') {

		$db_inserted = $wpdb->insert(
			'edge_tifs',
			array(
				'CompanyName' => $entry_list["CompanyName"],
				'Address' => $entry_list["Address"],
				'Address2' => $entry_list["Address2"],
				'City' => $entry_list["City"],
				'County' => $entry_list["County"],
				'State' => $entry_list["State"],
				'ZipCode' => $entry_list["ZipCode"],
				'Summary' => $entry_list["Summary"],
				'TIFAmount' => $entry_list["TIFAmount"],
				'TotalInvestment' => $entry_list["TotalInvestment"],
				'ProjectedMWBESpending' => $entry_list["ProjectedMWBESpending"],
				'ProjectedTotalJobs' => $entry_list["ProjectedTotalJobs"],
				'UseJobsInTotalJobCalculation' => $entry_list["UseJobsInTotalJobCalculation"],
				'DateApproved' => $entry_list["ApprovedDate"],
				'AreaCoordinates' => $entry_list["AreaCoordinates"],
				'FileLink' => $entry_list["FileLink"],
			)
		);
	} else if ($entry_name == 'loans') {
		$db_inserted = $wpdb->insert(
			'edge_loan_program',
			array(
				"CompanyName" => $entry_list["CompanyName"],
				"ProjectType" => $entry_list["ProjectType"],
				"LoanType" => $entry_list["LoanType"],
				"ProjectNumber" => $entry_list["ProjectNumber"],
				"Address" => $entry_list["Address"],
				"Address2" => $entry_list["Address2"],
				"City" => $entry_list["City"],
				"State" => $entry_list["State"],
				"ZipCode" => $entry_list["ZipCode"],
				"Lat" => $entry_list["Lat"],
				"Lng" => $entry_list["Lng"],
				"ProjectDescription" => $entry_list["ProjectDescription"],
				"CityCouncilDistrict" => $entry_list["CityCouncilDistrict"],
				"CityCouncilSuperDistrict" => $entry_list["CityCouncilSuperDistrict"],
				"CountyCommissionDistrict" => $entry_list["CountyCommissionDistrict"],
				"Term" => $entry_list["Term"],
				"ProjectedNewJobs" => $entry_list["ProjectedNewJobs"],
				"UseJobsInTotalJobCalculation" => $entry_list["UseJobsInTotalJobCalculation"],
				"ProjectedRetainedJobs" => $entry_list["ProjectedRetainedJobs"],
				"AveragePayroll" => $entry_list["AveragePayroll"],
				"DateApproved" => $entry_list["DateApproved"],
				"DateClosed" => $entry_list["DateClosed"],
				"LoanAmount" => $entry_list["LoanAmount"],
				"LoanUse" => $entry_list["LoanUse"],
				"InterestRate" => $entry_list["InterestRate"],
				"TotalProjectedCapitalInvestment" => $entry_list["TotalProjectedCapitalInvestment"],
				"PCI_RealProperty" => $entry_list["PCI_RealProperty"],
				"PCI_Acquisition" => $entry_list["PCI_Acquisition"],
				"PCI_Construction" => $entry_list["PCI_Construction"],
				"PCI_Renovation" => $entry_list["PCI_Renovation"],
				"PCI_MachineryEquipment" => $entry_list["PCI_MachineryEquipment"],
				"PCI_FurnitureFixturesOffice" => $entry_list["PCI_FurnitureFixturesOffice"],
				"PCI_Equipment" => $entry_list["PCI_Equipment"],
				"PCI_FeesSoftCosts" => $entry_list["PCI_FeesSoftCosts"],
				"PCI_PermanentWorkingCapital" => $entry_list["PCI_PermanentWorkingCapital"],
				"PCI_Miscellaneous" => $entry_list["PCI_Miscellaneous"],
				"Logo" => $entry_list["Logo"],
				"VideoThumbnail" => $entry_list["VideoThumbnail"],
				"VideoURL" => $entry_list["VideoURL"],
				"FileLink" => $entry_list["FileLink"],
			)
		);
	} else if ($entry_name == 'bonds') {
		$db_inserted = $wpdb->insert(
			'edge_bonds',
			array(
				"CompanyName" => $entry_list["CompanyName"],
				"Address" => $entry_list["Address"],
				"Address2" => $entry_list["Address2"],
				"City" => $entry_list["City"],
				"County" => $entry_list["County"],
				"State" => $entry_list["State"],
				"ZipCode" => $entry_list["ZipCode"],
				"ProjectDescription" => $entry_list["ProjectDescription"],
				"BondTerm" => $entry_list["BondTerm"],
				"BondAmount" => $entry_list["BondAmount"],
				"UseBondAmountInTotalBondAmountCalculation" => $entry_list["UseBondAmountInTotalBondAmountCalculation"],
				"TotalInvestment" => $entry_list["TotalInvestment"],
				"UseTotalInvestmentInTotalInvestmentCalculation" => $entry_list["UseTotalInvestmentInTotalInvestmentCalculation"],
				"ProjectedTotalJobs" => $entry_list["ProjectedTotalJobs"],
				"UseJobsInTotalJobCalculation" => $entry_list["UseJobsInTotalJobCalculation"],
				"DateApproved" => $entry_list["DateApproved"],
				"AreaCoordinates" => $entry_list["AreaCoordinates"],
				"FileLink" => $entry_list["FileLink"],
			)
		);
	} else if ($entry_name == 'others') {
		$db_inserted = $wpdb->insert(
			'edge_others',
			array(
				"CompanyName" => $entry_list["CompanyName"],
				"OtherType" => $entry_list["OtherType"],
				"Address" => $entry_list["Address"],
				"Address2" => $entry_list["Address2"],
				"City" => $entry_list["City"],
				"County" => $entry_list["County"],
				"State" => $entry_list["State"],
				"ZipCode" => $entry_list["ZipCode"],
				"Lat" => $entry_list["Lat"],
				"Lng" => $entry_list["Lng"],
				"ProjectDescription" => $entry_list["ProjectDescription"],
				"FinancingAmount" => $entry_list["FinancingAmount"],
				"CalculationType" => $entry_list["CalculationType"],
				"TotalInvestment" => $entry_list["TotalInvestment"],
				"UseTotalInvestmentInTotalInvestmentCalculation" => $entry_list["UseTotalInvestmentInTotalInvestmentCalculation"],
				"ProjectedTotalJobs" => $entry_list["ProjectedTotalJobs"],
				"UseJobsInTotalJobCalculation" => $entry_list["UseJobsInTotalJobCalculation"],
				"ValueUS" => $entry_list["ValueUS"],
				"Exports" => $entry_list["Exports"],
				"TotalShipments" => $entry_list["TotalShipments"],
				"Year" => $entry_list["Year"],
				"DateApproved" => $entry_list["DateApproved"],
				"BondTerm" => $entry_list["BondTerm"],
				"FileLink" => $entry_list["FileLink"],
			)
		);
	}

	if (!$db_inserted) {
		echo "\n" . "FAILED TO Insert: " . $db_inserted . "\n" . ($_POST['table']) . "\n" . $entry_name . "\n" . $entry_list . "\n";
	} else {
		$db_inserted;
		echo "WILL UPDATE SUCCESSFULLY - CALL RESULT FUNCTION" . ($_POST['table']) . "\n" . $entry_name . "\n" . $entry_list . "\n";
		edge_db_page_contents();
	};

	wp_die();
}
add_action("wp_ajax_insert_records_callback", "insert_records_callback");

function update_records_callback()
{
	global $wpdb;
	$db_updated = $wpdb->update(
		$_POST['table'],
		array($_POST['key']  => $_POST['new_value']), // New Values
		array($_POST['key'] => $_POST['value']) // Old Values
	);

	if (!$db_updated) {
		echo "FAILED TO UPDATE: " . $db_updated . "\n"
			. $_POST['table'] . "\n" . $_POST['key'] . "\n" . $_POST['value'] . "\n" . $_POST['new_value'] . "\n";
	} else {
		$db_updated;
		echo "WILL UPDATE SUCCESSFULLY - CALL RESULT FUNCTION";
	};

	wp_die();
}
add_action("wp_ajax_update_records_callback", "update_records_callback");

function delete_records_callback()
{
	global $wpdb;
	$db_deleted = $wpdb->delete(
		$_POST['table'],
		array($_POST['key'] => $_POST['value'])
	);

	if (!$db_deleted) {
		echo "FAILED TO DELETE: " . $db_deleted . "\n"
			. $_POST['table'] . "\n" . $_POST['key'] . "\n"
			. $_POST['value'];
	} else {
		$db_deleted;
		echo "WILL DELETE SUCCESSFULLY - CALL RESULT FUNCTION";
	};

	wp_die();
}
add_action("wp_ajax_delete_records_callback", "delete_records_callback");

function edge_db_page_contents()
{
	global $wpdb;
	$edge_bonds =  wp_json_encode(
		$wpdb->get_results(
			$wpdb->prepare(
				"SELECT * FROM edge_bonds"
			)
		)
	);

	$edge_loans =  wp_json_encode(
		$wpdb->get_results(
			$wpdb->prepare(
				"SELECT * FROM edge_loan_program"
			)
		)
	);

	$edge_others =  wp_json_encode(
		$wpdb->get_results(
			$wpdb->prepare(
				"SELECT * FROM edge_others"
			)
		)
	);

	$edge_pilots =  wp_json_encode(
		$wpdb->get_results(
			$wpdb->prepare(
				"SELECT * FROM edge_pilot_program"
			)
		)
	);

	$edge_tifs = wp_json_encode(
		$wpdb->get_results(
			$wpdb->prepare(
				"SELECT * FROM edge_tifs"
			)
		)
	);

	$wpdb->flush();

?>
	<link href="https://fonts.googleapis.com/icon?family=Material+Icons" rel="stylesheet">
	<script src="https://cdn.tailwindcss.com"></script>
	<script src="https://ajax.googleapis.com/ajax/libs/jquery/3.6.0/jquery.min.js"></script>

	<style>
		.edge-red {
			color: rgba(138, 31, 3, 1);
		}

		.edge-link-red {
			color: rgba(138, 31, 3, 1);
			cursor: pointer;
		}

		.edge-link-red:hover {
			color: rgba(153, 153, 153, 1);
		}

		.edge-link-gray {
			color: rgba(204, 204, 204, 1);
			cursor: pointer;
		}

		.edge-link-gray:hover {
			color: rgba(153, 153, 153, 1);
		}

		#list-menu>div {
			color: rgba(204, 204, 204, 1);
			cursor: pointer;
		}

		#list-menu>div:first-child {
			color: rgba(138, 31, 3, 1);
		}

		#list-menu>div:hover {
			color: rgba(153, 153, 153, 1);
		}

		#list-data {
			width: 98%;
		}

		#list-content,
		#content-display {
			max-width: 1280px;
		}

		#list-content>div>div:hover {
			background-color: rgba(153, 153, 153, 1);
			cursor: pointer;
		}

		#content-display {
			font-size: 1rem;
		}
	</style>

	<script>
		function sanitizeString(str) {
			str = str.replace(/'|"|`|;|\[|\]|\{|\}/g, "");
			str = str.replace(/INSERT|INSERT INTO|SELECT \*|SELECT|SELECT \* FROM|WHERE|SELECT DISTINCT|FROM|VALUES|UPDATE|SET|DELETE FROM|DELETE/g, "");
			return str.trim();
		}

		var current_list = "pilots";
		var current_listing;
		var editing = false;
		var pilot_address_count = 1;

		var pilots = JSON.stringify(<?php echo $edge_pilots; ?>);
		var tifs = JSON.stringify(<?php echo $edge_tifs; ?>);
		var loans = JSON.stringify(<?php echo $edge_loans; ?>);
		var bonds = JSON.stringify(<?php echo $edge_bonds; ?>);
		var others = JSON.stringify(<?php echo $edge_others; ?>);

		var PilotProjectTypes = [
			"None",
			"Distribution",
			"Manufacturing",
			"Neighborhood Project",
			"Office/HQ",
			"Residential",
			"Retail",
			"Other",
		];

		var PilotTypes = [
			"None",
			"Community Builder",
			"Expansion",
			"Fast Track",
			"Jobs",
			"Residential",
			"Retention",
			"Sewer Capacity",
			"Standard/Basic",
			"Other",
		];

		var PilotStatuses = [
			"None",
			"Approved",
			"Terminated",
			"Other",
		];

		var OtherTypes = [
			"None",
			"Tennessee FastTrack Economic Development Grant",
			"EDGE Economic Development Grant",
			"NEED Grant",
			"Shelby County Grant",
			"FTZ-77",
			"Other",
		];

		var LoanTypes = [
			"None",
			"Inner City Economic Development Loan",
			"EDGE Loan Fund Loan",
			"SBA 504 Loan",
			"Other",
		];

		var LoanProjectTypes = [
			"None",
			"Neighborhood Project",
			"Office/HQ",
			"Other",
		];

		var pilotColumns = ['CompanyName', 'ProjectNumber', 'ProjectType', 'PilotType', 'PilotStatus', 'NewConstruction', 'ProjectDescription', 'PilotTerm', 'ProjectedTaxesAbatedCity', 'ProjectedTaxesAbatedCityPercent', 'ProjectedTaxesAbatedCounty', 'ProjectedTaxesAbatedCountyPercent', 'DateApproved', 'DateClosedRealProperty', 'DateClosedPersonalProperty', 'DateClosedEffectiveDate', 'LeaseBeginsRealProperty', 'LeaseBeginsPersonalProperty', 'LeaseExpiresRealProperty', 'LeaseExpiresPersonalProperty', 'DateAmended01', 'DateAmended02', 'DateAmended03', 'DateAmended04', 'DateAmended05', 'RampUpPeriod', 'ProjectedNewJobs', 'ProjectedAveragePayrollOfNewJobs', 'TotalNewPayroll', 'ProjectedRetainedJobs', 'ProjectedAveragePayrollOfRetainedJobs', 'TotalRetainedPayroll', 'TotalJobs', 'EmploymentDirect', 'EmploymentIndirect', 'WagesDirect', 'WagesIndirect', 'ProjectedCapitalInvestment', 'RealPropertyInvestment', 'PersonalPropertyInvestment', 'CommunityReinvestmentCredit', 'CapitalInvestmentNotInPilot', 'ProjectedMWBE_LOSBSpending', 'MWBE_LOSBSpendingConstruction', 'MWBE_LOSBSpendingOperations', 'TotalCapitalInvestment', 'TotalIncentiveProvided', 'TotalNewTaxRevenues', 'BenefitCostRatio', 'ParcelID', 'CityCouncilDistrict', 'CityCouncilSuperDistrict', 'CountyCommissionDistrict', 'TotalRealPropertyTaxesBefore', 'TotalPersonalPropertyTaxesBefore', 'TotalRealPropertyTaxesDuring', 'TotalPersonalPropertyTaxesDuring', 'TotalRealPropertyTaxesAfter', 'TotalPersonalPropertyTaxesAfter', 'logo', 'VideoThumbnail', 'VideoURL', 'ProjectLocation', 'Lat', 'Lng', 'Address', 'Address2', 'City', 'State', 'ZipCode', 'Address02_Lat', 'Address02_Lng', 'Address02_Address', 'Address02_Address2', 'Address02_City', 'Address02_State', 'Address02_ZipCode', 'Address03_Lat', 'Address03_Lng', 'Address03_Address', 'Address03_Address2', 'Address03_City', 'Address03_State', 'Address03_ZipCode', 'Address04_Lat', 'Address04_Lng', 'Address04_Address', 'Address04_Address2', 'Address04_City', 'Address04_State', 'Address04_ZipCode', 'Address05_Lat', 'Address05_Lng', 'Address05_Address', 'Address05_Address2', 'Address05_City', 'Address05_State', 'Address05_ZipCode', 'Address06_Lat', 'Address06_Lng', 'Address06_Address', 'Address06_Address2', 'Address06_City', 'Address06_State', 'Address06_ZipCode', 'Address07_Lat', 'Address07_Lng', 'Address07_Address', 'Address07_Address2', 'Address07_City', 'Address07_State', 'Address07_ZipCode', 'Address08_Lat', 'Address08_Lng', 'Address08_Address', 'Address08_Address2', 'Address08_City, Address08_State', 'Address08_ZipCode', 'total_square_footage', 'number_of_apartment_units', 'incentive_approved', 'date_closed', 'lease_begins', 'lease_expires', 'avg_payroll_projected_retained', 'FileLink'];

		var pilotIntCols = ["ProjectedTaxesAbatedCity", "ProjectedTaxesAbatedCounty", "ProjectedTaxesAbatedCityPercent", "ProjectedTaxesAbatedCountyPercent", "ProjectedNewJobs", "ProjectedAveragePayrollOfNewJobs", "TotalNewPayroll", "ProjectedRetainedJobs", "ProjectedAveragePayrollOfRetainedJobs", "TotalRetainedPayroll", "EmploymentDirect", "EmploymentIndirect", "WagesDirect", "WagesIndirect", "ProjectedCapitalInvestment", "RealPropertyInvestment", "PersonalPropertyInvestment", "CommunityReinvestmentCredit", "CapitalInvestmentNotInPilot", "ProjectedMWBE_LOSBSpending", "MWBE_LOSBSpendingConstruction", "MWBE_LOSBSpendingOperations", "TotalCapitalInvestment", "TotalIncentiveProvided", "TotalNewTaxRevenues", "TotalRealPropertyTaxesBefore", "TotalRealPropertyTaxesAfter", "TotalRealPropertyTaxesDuring", "TotalPersonalPropertyTaxesAfter", "TotalPersonalPropertyTaxesBefore", "TotalPersonalPropertyTaxesDuring", "total_square_footage", "number_of_apartment_units", "avg_payroll_projected_retained"];

		var loanColumns = ['CompanyName', 'ProjectType', 'LoanType', 'ProjectNumber', 'Address', 'Address2', 'City', 'State', 'ZipCode', 'Lat', 'Lng', 'ProjectDescription', 'CityCouncilDistrict', 'CityCouncilSuperDistrict', 'CountyCommissionDistrict', 'Term', 'ProjectedNewJobs', 'UseJobsInTotalJobCalculation', 'ProjectedRetainedJobs', 'AveragePayroll', 'DateApproved', 'DateClosed', 'LoanAmount', 'LoanUse', 'InterestRate', 'TotalProjectedCapitalInvestment', 'PCI_RealProperty', 'PCI_Acquisition', 'PCI_Construction', 'PCI_Renovation', 'PCI_MachineryEquipment', 'PCI_FurnitureFixturesOffice', 'PCI_Equipment', 'PCI_FeesSoftCosts', 'PCI_PermanentWorkingCapital', 'PCI_Miscellaneous', 'Logo', 'VideoThumbnail', 'VideoURL'];

		var loanIntCols = ["ZipCode", "ProjectedNewJobs", "UseJobsInTotalJobCalculation", "ProjectedRetainedJobs", "AveragePayroll", "LoanAmount", "TotalProjectedCapitalInvestment", 'PCI_RealProperty', 'PCI_Acquisition', "PCI_Construction", "PCI_Renovation", "PCI_MachineryEquipment", "PCI_FurnitureFixturesOffice", "PCI_Equipment", "PCI_FeesSoftCosts", "PCI_PermanentWorkingCapital", "PCI_Miscellaneous"];

		var bondColumns = ["CompanyName", "Address", "Address2", "City", "County", "State", "ZipCode", "ProjectDescription", "BondTerm", "BondAmount", "UseBondAmountInTotalBondAmountCalculation", "TotalInvestment", "UseTotalInvestmentInTotalInvestmentCalculation", "ProjectedTotalJobs", "UseJobsInTotalJobCalculation", "DateApproved", "AreaCoordinates", "FileLink"];

		var bondIntCols = ["BondTerm", "BondAmount", "UseBondAmountInTotalBondAmountCalculation", "TotalInvestment", "UseTotalInvestmentInTotalInvestmentCalculation", "ProjectedTotalJobs", "UseJobsInTotalJobCalculation"];

		var tifColumns = ["CompanyName", "Address", "Address2", "City", "County", "State", "ZipCode", "Summary", "TIFAmount", "TotalInvestment", "ProjectedMWBESpending", "ProjectedTotalJobs", "UseJobsInTotalJobCalculation", "DateApproved", "AreaCoordinates"];

		var tifIntCols = ["TIFAmount", "TotalInvestment", "ProjectedMWBESpending", "ProjectedTotalJobs", "UseJobsInTotalJobCalculation"];

		var otherColumns = ["CompanyName", "OtherType", "Address", "Address2", "City", "County", "State", "ZipCode", "Lat", "Lng", "ProjectDescription", "FinancingAmount", "CalculationType", "TotalInvestment", "UseTotalInvestmentInTotalInvestmentCalculation", "ProjectedTotalJobs", "UseJobsInTotalJobCalculation", "ValueUS", "Exports", "TotalShipments", "Year", "DateApproved", "BondTerm"];

		var otherIntCols = ["FinancingAmount", "TotalInvestment", "UseTotalInvestmentInTotalInvestmentCalculation", "ProjectedTotalJobs", "UseJobsInTotalJobCalculation", "ValueUS", "Exports", "TotalShipments", "Year"];


		function _Pilot() {
			this.CompanyName = "";
			this.ProjectNumber = "";
			this.ProjectType = "";
			this.PilotType = "";
			this.PilotStatus = "";
			this.NewConstruction = "";
			this.ProjectDescription = "";
			this.PilotTerm = "";
			this.ProjectedTaxesAbatedCity = "";
			this.ProjectedTaxesAbatedCityPercent = "";
			this.ProjectedTaxesAbatedCounty = "";
			this.ProjectedTaxesAbatedCountyPercent = "";
			this.DateApproved = "";
			this.DateClosedRealProperty = "";
			this.DateClosedPersonalProperty = "";
			this.DateClosedEffectiveDate = "";
			this.LeaseBeginsRealProperty = "";
			this.LeaseBeginsPersonalProperty = "";
			this.LeaseExpiresRealProperty = "";
			this.LeaseExpiresPersonalProperty = "";
			this.DateAmended01 = "";
			this.DateAmended02 = "";
			this.DateAmended03 = "";
			this.DateAmended04 = "";
			this.DateAmended05 = "";
			this.RampUpPeriod = "";
			this.ProjectedNewJobs = "";
			this.ProjectedAveragePayrollOfNewJobs = "";
			this.TotalNewPayroll = "";
			this.ProjectedRetainedJobs = "";
			this.ProjectedAveragePayrollOfRetainedJobs = "";
			this.TotalRetainedPayroll = "";
			this.TotalJobs = "";
			this.EmploymentDirect = "";
			this.EmploymentIndirect = "";
			this.WagesDirect = "";
			this.WagesIndirect = "";
			this.ProjectedCapitalInvestment = "";
			this.RealPropertyInvestment = "";
			this.PersonalPropertyInvestment = "";
			this.CommunityReinvestmentCredit = "";
			this.apitalInvestmentNotInPilot = "";
			this.ProjectedMWBE_LOSBSpending = "";
			this.MWBE_LOSBSpendingConstruction = "";
			this.MWBE_LOSBSpendingOperations = "";
			this.TotalCapitalInvestment = "";
			this.TotalIncentiveProvided = "";
			this.TotalNewTaxRevenues = "";
			this.BenefitCostRatio = "";
			this.ParcelID = "";
			this.CityCouncilDistrict = "";
			this.CityCouncilSuperDistrict = "";
			this.CountyCommissionDistrict = "";
			this.TotalRealPropertyTaxesBefore = "";
			this.TotalPersonalPropertyTaxesBefore = "";
			this.TotalRealPropertyTaxesDuring = "";
			this.TotalPersonalPropertyTaxesDuring = "";
			this.TotalRealPropertyTaxesAfter = "";
			this.TotalPersonalPropertyTaxesAfter = "";
			this.logo = "";
			this.VideoThumbnail = "";
			this.VideoURL = "";
			this.ProjectLocation = "";
			this.Lat = "";
			this.Lng = "";
			this.Address = "";
			this.Address2 = "";
			this.City = "";
			this.State = "";
			this.ZipCode = "";
			this.Address02_Lat = "";
			this.Address02_Lng = "";
			this.Address02_Address = "";
			this.Address02_Address2 = "";
			this.Address02_City = "";
			this.Address02_State = "";
			this.Address02_ZipCode = "";
			this.Address03_Lat = "";
			this.Address03_Lng = "";
			this.Address03_Address = "";
			this.Address03_Address2 = "";
			this.Address03_City = "";
			this.Address03_State = "";
			this.Address03_ZipCode = "";
			this.Address04_Lat = "";
			this.Address04_Lng = "";
			this.Address04_Address = "";
			this.Address04_Address2 = "";
			this.Address04_City = "";
			this.Address04_State = "";
			this.Address04_ZipCode = "";
			this.Address05_Lat = "";
			this.Address05_Lng = "";
			this.Address05_Address = "";
			this.Address05_Address2 = "";
			this.Address05_City = "";
			this.Address05_State = "";
			this.Address05_ZipCode = "";
			this.Address06_Lat = "";
			this.Address06_Lng = "";
			this.Address06_Address = "";
			this.Address06_Address2 = "";
			this.Address06_City = "";
			this.Address06_State = "";
			this.Address06_ZipCode = "";
			this.Address07_Lat = "";
			this.Address07_Lng = "";
			this.Address07_Address = "";
			this.Address07_Address2 = "";
			this.Address07_City = "";
			this.Address07_State = "";
			this.Address07_ZipCode = "";
			this.Address08_Lat = "";
			this.Address08_Lng = "";
			this.Address08_Address = "";
			this.Address08_Address2 = "";
			this.Address08_City = "";
			this.Address08_State = "";
			this.Address08_ZipCode = "";
			this.total_square_footage = "";
			this.number_of_apartment_units = "";
			this.incentive_approved = "";
			this.date_closed = "";
			this.lease_begins = "";
			this.lease_expires = "";
			this.avg_payroll_projected_retained = "";
			this.FileLink = "";
		}

		function _Loan() {
			this.CompanyName = "";
			this.ProjectType = "";
			this.LoanType = "";
			this.ProjectNumber = "";
			this.Address = "";
			this.Address2 = "";
			this.City = "";
			this.State = "";
			this.ZipCode = "";
			this.Lat = "";
			this.Lng = "";
			this.ProjectDescription = "";
			this.CityCouncilDistrict = "";
			this.CityCouncilSuperDistrict = "";
			this.CountyCommissionDistrict = "";
			this.Term = "";
			this.ProjectedNewJobs = "";
			this.UseJobsInTotalJobCalculation = "";
			this.ProjectedRetainedJobs = "";
			this.AveragePayroll = "";
			this.DateApproved = "";
			this.DateClosed = "";
			this.LoanAmount = "";
			this.LoanUse = "";
			this.InterestRate = "";
			this.TotalProjectedCapitalInvestment = "";
			this.PCI_RealProperty = "";
			this.PCI_Acquisition = "";
			this.PCI_Construction = "";
			this.PCI_Renovation = "";
			this.PCI_MachineryEquipment = "";
			this.PCI_FurnitureFixturesOffice = "";
			this.PCI_Equipment = "";
			this.PCI_FeesSoftCosts = "";
			this.PCI_PermanentWorkingCapital = "";
			this.PCI_Miscellaneous = "";
			this.Logo = "";
			this.VideoThumbnail = "";
			this.VideoURL = "";
			this.FileLink = "";
		}

		function _Bond() {
			this.CompanyName = "";
			this.Address = "";
			this.Address2 = "";
			this.City = "";
			this.County = "";
			this.State = "";
			this.ZipCode = "";
			this.ProjectDescription = "";
			this.BondTerm = "";
			this.BondAmount = "";
			this.UseBondAmountInTotalBondAmountCalculation = "";
			this.TotalInvestment = "";
			this.UseTotalInvestmentInTotalInvestmentCalculation = "";
			this.ProjectedTotalJobs = "";
			this.UseJobsInTotalJobCalculation = "";
			this.DateApproved = "";
			this.AreaCoordinates = "";
			this.FileLink = "";
		}

		function _Tif() {
			this.CompanyName = "";
			this.Address = "";
			this.Address2 = "";
			this.City = "";
			this.County = "";
			this.State = "";
			this.ZipCode = "";
			this.Summary = "";
			this.TIFAmount = "";
			this.TotalInvestment = "";
			this.ProjectedMWBESpending = "";
			this.ProjectedTotalJobs = "";
			this.UseJobsInTotalJobCalculation = "";
			this.DateApproved = "";
			this.AreaCoordinates = "";
			this.FileLink = "";
		}

		function _Other() {
			this.CompanyName = "";
			this.OtherType = "";
			this.Address = "";
			this.Address2 = "";
			this.City = "";
			this.County = "";
			this.State = "";
			this.ZipCode = "";
			this.Lat = "";
			this.Lng = "";
			this.ProjectDescription = "";
			this.FinancingAmount = "";
			this.CalculationType = "";
			this.TotalInvestment = "";
			this.UseTotalInvestmentInTotalInvestmentCalculation = "";
			this.ProjectedTotalJobs = "";
			this.UseJobsInTotalJobCalculation = "";
			this.ValueUS = "";
			this.Exports = "";
			this.TotalShipments = "";
			this.Year = "";
			this.DateApproved = "";
			this.BondTerm = "";
			this.FileLink = "";
		}

		function addToDatabase() {
			if (current_list == "pilots") {
				var _colNames = pilotColumns;
				var _intCols = pilotIntCols;
				var _entry = new _Pilot();
				var _table = "edge_pilot_program";
			} else if (current_list == 'bonds') {
				var _colNames = bondColumns;
				var _intCols = bondIntCols;
				var _entry = new _Bond();
				var _table = "edge_bonds";
			} else if (current_list == 'loans') {
				var _colNames = loanColumns;
				var _intCols = loanIntCols;
				var _entry = new _Loan();
				var _table = "edge_loan_program";
			} else if (current_list == 'tifs') {
				var _colNames = tifColumns;
				var _intCols = tifIntCols;
				var _entry = new _Tif();
				var _table = "edge_tifs";
			} else if (current_list == 'others') {
				var _colNames = otherColumns;
				var _intCols = otherIntCols;
				var _entry = new _Other();
				var _table = "edge_others";
			}

			_colNames.forEach(key => {
				var new_value = $("#" + key).val();
				if (key == "NewConstruction") {
					new_value = $("#NewConstruction").is(":checked") ? 1 : 0;
					_entry.NewConstruction = new_value;
				} else if (key == "UseJobsInTotalJobCalculation") {
					new_value = $("#UseJobsInTotalJobCalculation").is(":checked") ? 1 : 0;
					_entry.UseJobsInTotalJobCalculation = new_value;
				} else if (key == "UseBondAmountInTotalBondAmountCalculation") {
					new_value = $("#UseBondAmountInTotalBondAmountCalculation").is(":checked") ? 1 : 0;
					_entry.UseBondAmountInTotalBondAmountCalculation = new_value;
				} else if (key == "UseTotalInvestmentInTotalInvestmentCalculation") {
					new_value = $("#UseTotalInvestmentInTotalInvestmentCalculation").is(":checked") ? 1 : 0;
					_entry.UseTotalInvestmentInTotalInvestmentCalculation = new_value;
				} else if (key == "UseJobsInTotalJobCalculation") {
					new_value = $("#UseJobsInTotalJobCalculation").is(":checked") ? 1 : 0;
					_entry.UseTotalInvestmentInTotalInvestmentCalculation = new_value;
				}

				if (_intCols.includes(key)) {
					new_value = parseInt(new_value);
					if (new_value >= 0 && !isNaN(new_value) && !isNaN(parseInt(new_value))) {
						new_value = parseInt(new_value);
					} else {
						new_value = 0;
					}
				}

				if (new_value != undefined &&
					new_value != null &&
					new_value != 'undefined' &&
					new_value != 'null') {
					if (typeof new_value == 'string') {
						_entry[key] = sanitizeString(new_value);
					} else {
						_entry[key] = new_value;
					}
				} else {
					_entry[key] = "";
				}
			});

			// console.log(_entry);

			current_listing = _entry;

			var data = {
				'action': 'insert_records_callback',
				'entry': [current_list, _entry],
				'table': _table
			}
			var ajaxurl = "<?php echo admin_url('admin-ajax.php'); ?>";
			jQuery.post(ajaxurl, data, function(response) {
				console.log(response);
				editing = false;
				$(window).scrollTop(0);
				current_listing = _entry;
				var r = confirm("Listing has been added.");
				if (r == true || r == false) {
					location.reload();
				}
			});
		}

		function updateInDatabase() {
			if (current_list == "pilots") {
				var _colNames = pilotColumns;
				var _intCols = pilotIntCols;
				var _entry = new _Pilot();
				var _table = "edge_pilot_program";
			} else if (current_list == 'bonds') {
				var _colNames = bondColumns;
				var _intCols = bondIntCols;
				var _entry = new _Bond();
				var _table = "edge_bonds";
			} else if (current_list == 'loans') {
				var _colNames = loanColumns;
				var _intCols = loanIntCols;
				var _entry = new _Loan();
				var _table = "edge_loan_program";
			} else if (current_list == 'tifs') {
				var _colNames = tifColumns;
				var _intCols = tifIntCols;
				var _entry = new _Tif();
				var _table = "edge_tifs";
			} else if (current_list == 'others') {
				var _colNames = otherColumns;
				var _intCols = otherIntCols;
				var _entry = new _Other();
				var _table = "edge_others";
			}


			_colNames.forEach(key => {
				var new_value = $("#" + key).val();
				var value = current_listing[key];

				if (key == "NewConstruction") {
					new_value = $("#NewConstruction").is(":checked") ? 1 : 0;
					_entry.NewConstruction = new_value;
				} else if (key == "UseJobsInTotalJobCalculation") {
					new_value = $("#UseJobsInTotalJobCalculation").is(":checked") ? 1 : 0;
					_entry.UseJobsInTotalJobCalculation = new_value;
				} else if (key == "UseBondAmountInTotalBondAmountCalculation") {
					new_value = $("#UseBondAmountInTotalBondAmountCalculation").is(":checked") ? 1 : 0;
					_entry.UseBondAmountInTotalBondAmountCalculation = new_value;
				} else if (key == "UseTotalInvestmentInTotalInvestmentCalculation") {
					new_value = $("#UseTotalInvestmentInTotalInvestmentCalculation").is(":checked") ? 1 : 0;
					_entry.UseTotalInvestmentInTotalInvestmentCalculation = new_value;
				} else if (key == "UseJobsInTotalJobCalculation") {
					new_value = $("#UseJobsInTotalJobCalculation").is(":checked") ? 1 : 0;
					_entry.UseTotalInvestmentInTotalInvestmentCalculation = new_value;
				}

				if (_intCols.includes(key)) {
					new_value = parseInt(new_value);
					if (new_value >= 0 && !isNaN(new_value) && !isNaN(parseInt(new_value))) {
						new_value = parseInt(new_value);
					} else {
						if (parseInt(value) >= 0 && !isNaN(value) && !isNaN(parseInt(value))) {
							new_value = parseInt(value);
						} else {
							new_value = 0;
						}
					}
				}

				if (new_value != undefined &&
					new_value != null &&
					new_value != 'undefined' &&
					new_value != 'null') {
					if (typeof new_value == 'string') {
						_entry[key] = sanitizeString(new_value);
					} else {
						_entry[key] = new_value;
					}
				} else {
					_entry[key] = "";
				}

				var data = {
					'action': 'update_records_callback',
					'table': _table,
					"key": key,
					"value": value,
					"new_value": new_value,
				}
				if (value != null && new_value != null && value != new_value) {
					var ajaxurl = "<?php echo admin_url('admin-ajax.php'); ?>";
					jQuery.post(ajaxurl, data, function(response) {
						$(window).scrollTop(0);
						current_listing = _entry;
						var r = confirm("Listing has been updated.");
						if (r == true || r == false) {
							location.reload();
						}
						console.log(response);
					});
				}
			});
		}

		function deleteFromDatabase() {
			if (current_list == "pilots") {
				var _table = "edge_pilot_program";
			} else if (current_list == 'bonds') {
				var _table = "edge_bonds";
			} else if (current_list == 'loans') {
				var _table = "edge_loan_program";
			} else if (current_list == 'tifs') {
				var _table = "edge_tifs";
			} else if (current_list == 'others') {
				var _table = "edge_others";
			}

			var data = {
				'action': 'delete_records_callback',
				'table': _table,
				"key": "Id",
				"value": current_listing.Id
			}
			var ajaxurl = "<?php echo admin_url('admin-ajax.php'); ?>";
			jQuery.post(ajaxurl, data, function(response) {
				console.log(response);
				location.reload(true);
			});
		}

		function deleteConfirmation() {
			var r = confirm("Are you sure you want to delete this listing? All info will be lost and removed from the database.");
			if (r == true) {
				deleteFromDatabase();
			}
		}

		function backToList() {
			var r = confirm("Do you sure you wish to leave this listing? All new info will be lost.");
			if (r == true) {
				if (current_list == "pilots") {
					set_up_data(pilots);
				} else if (current_list == "bonds") {
					set_up_data(bonds);
				} else if (current_list == "loans") {
					set_up_data(loans);
				} else if (current_list == "tifs") {
					set_up_data(tifs);
				} else if (current_list == "others") {
					set_up_data(others);
				}
				$("#content-display").html("");
			}
		}

		function openListing(li) {
			let html = "";
			editing = true;
			current_listing = li;

			if (current_list == "pilots") {
				$('#list-data').html("");

				html += `
				<div class="text-xl font-bold mb-8 flex items-center justify-between">
				<div>Update PILOT Form</div>
				<button class="bg-blue-300 hover:bg-gray-600 hover:text-white py-2 px-6 rounded-md" onclick="backToList()" id="back">Back</button>
				<button class="bg-red-300 hover:bg-gray-600 hover:text-white py-2 px-6 rounded-md" onclick="deleteConfirmation()" id="delete-confirm">Delete</button>
				</div>

				<div class="w-full grid grid-cols-9 gap-4">
					<div class="col-span-2">Company Name</div>
					<div class="col-span-7">
						<input placeholder="New Company Name" type="text" id="CompanyName" value="${li.CompanyName}" />
					</div>

					<div class="col-span-2">Project Number</div>
					<div class="col-span-7">
						<input placeholder="1234567890" type="text" id="ProjectNumber" value="${li.ProjectNumber}" />
					</div>

					<div class="col-span-2">Parcel ID</div>
					<div class="col-span-7">
						<input placeholder="1234_ABCD" type="text" id="ParcelID" value="${li.ParcelID}" />
					</div>

					<div class="col-span-2">Project Type</div>
					<div class="col-span-7">
						<select id="ProjectType" />`;
				for (pt of PilotProjectTypes) {
					if (li.ProjectType == pt) {
						html += `<option value="${pt}" selected>${pt}</option>`;
					} else {
						html += `<option value="${pt}">${pt}</option>`;
					}
				}
				html += `</select>
					</div>

					<div class="col-span-2">PILOT Type</div>
					<div class="col-span-7">
						<select placeholder="PILOT Type" id="PilotType" />`;
				for (pt of PilotTypes) {
					if (li.PilotType == pt) {
						html += `<option value="${pt}" selected>${pt}</option>`;
					} else {
						html += `<option value="${pt}">${pt}</option>`;
					}
				}
				html += `</select>
					</div>

					<div class="col-span-2">PILOT Status</div>
					<div class="col-span-7">
						<select placeholder="PILOT Status" id="PilotStatus" />`;
				for (ps of PilotStatuses) {
					if (li.PilotStatus == ps) {
						html += `<option value="${ps}" selected>${ps}</option>`;
					} else {
						html += `<option value="${ps}">${ps}</option>`;
					}
				}

				if (li.NewConstruction == 1) {
					var _NC_Checked = "checked";
				} else {
					var _NC_Checked = "";
				}

				html += `</select>
					</div>

					<div class="col-span-2">Is New Construction?</div>
					<div class="col-span-7">
						<input type="checkbox" id="NewConstruction" ${_NC_Checked}/>
					</div>

					<div class="col-span-2">Project Description</div>
					<div class="col-span-7">
						<textarea class="p-2 w-9/12" placeholder="Describe the project." id="ProjectDescription">${li.ProjectDescription}</textarea>
					</div>

					<div class="col-span-2">Term Length</div>
					<div class="col-span-7">
						<input placeholder="2 Years" type="text" id="PilotTerm" value="${li.PilotTerm}" />
					</div>

					<div class="col-span-2">Address</div>
					<div class="col-span-7 flex gap-4">
						<div class="grid grid-cols-1 sm:grid-cols-2 gap-x-4 gap-y-8">
							<div id="A1" class="col-span-1 grid grid-cols-2 gap-2">
								<div class="col-span-1">Street Number</div>
								<input class="col-span-1" placeholder="1234 Happy St." type="text" id="Address" value="${li.Address}"/>
								<div class="col-span-1">Street Number Cont.</div>
								<input class="col-span-1" placeholder="Apt # 4" type="text" id="Address2" value="${li.Address2}"/>
								<div class="col-span-1">City</div>
								<input class="col-span-1" placeholder="Memphis" type="text" id="City" value="${li.City}"/>
								<div class="col-span-1">State</div>
								<input class="col-span-1" placeholder="TN" type="text" id="State" value="${li.State}"/>
								<div class="col-span-1">Zip Code</div>
								<input class="col-span-1" placeholder="12345" type="text" id="ZipCode" value="${li.ZipCode}"/>
								<div class="col-span-1">Latitude</div>
								<input class="col-span-1" placeholder="1.2345" type="text" id="Lat" value="${li.Lat}"/>
								<div class="col-span-1">Longitude</div>
								<input class="col-span-1" placeholder="1.2345" type="text" id="Lng" value="${li.Lng}"/>
							</div>
							<div id="A2" class="col-span-1 grid grid-cols-2 gap-2">
								<div class="col-span-1">Street Number</div>
								<input class="col-span-1" placeholder="1234 Happy St." type="text" id="Address02_Address" value="${li.Address02_Address}"/>
								<div class="col-span-1">Street Number Cont.</div>
								<input class="col-span-1" placeholder="Apt # 4" type="text" id="Address02_Address2" value="${li.Address02_Address2}"/>
								<div class="col-span-1">City</div>
								<input class="col-span-1" placeholder="Memphis" type="text" id="Address02_City" value="${li.Address02_City}"/>
								<div class="col-span-1">State</div>
								<input class="col-span-1" placeholder="TN" type="text" id="Address02_State" value="${li.Address02_State}"/>
								<div class="col-span-1">Zip Code</div>
								<input class="col-span-1" placeholder="12345" type="text" id="Address02_ZipCode" value="${li.Address02_ZipCode}"/>
								<div class="col-span-1">Latitude</div>
								<input class="col-span-1" placeholder="1.2345" type="text" id="Address02_Lat" value="${li.Address02_Lat}"/>
								<div class="col-span-1">Longitude</div>
								<input class="col-span-1" placeholder="1.2345" type="text" id="Address02_Lng" value="${li.Address02_Lng}"/>
							</div>
							<div id="A3" class="col-span-1 grid grid-cols-2 gap-2">
								<div class="col-span-1">Street Number</div>
								<input class="col-span-1" placeholder="1234 Happy St." type="text" id="Address03_Address" value="${li.Address03_Address}"/>
								<div class="col-span-1">Street Number Cont.</div>
								<input class="col-span-1" placeholder="Apt # 4" type="text" id="Address03_Address2" value="${li.Address03_Address2}"/>
								<div class="col-span-1">City</div>
								<input class="col-span-1" placeholder="Memphis" type="text" id="Address03_City" value="${li.Address03_City}"/>
								<div class="col-span-1">State</div>
								<input class="col-span-1" placeholder="TN" type="text" id="Address03_State" value="${li.Address03_State}"/>
								<div class="col-span-1">Zip Code</div>
								<input class="col-span-1" placeholder="12345" type="text" id="Address03_ZipCode" value="${li.Address03_ZipCode}"/>
								<div class="col-span-1">Latitude</div>
								<input class="col-span-1" placeholder="1.2345" type="text" id="Address03_Lat" value="${li.Address03_Lat}"/>
								<div class="col-span-1">Longitude</div>
								<input class="col-span-1" placeholder="1.2345" type="text" id="Address03_Lng" value="${li.Address03_Lng}"/>
							</div>
							<div id="A4" class="col-span-1 grid grid-cols-2 gap-2">
								<div class="col-span-1">Street Number</div>
								<input class="col-span-1" placeholder="1234 Happy St." type="text" id="Address04_Address" value="${li.Address04_Address}"/>
								<div class="col-span-1">Street Number Cont.</div>
								<input class="col-span-1" placeholder="Apt # 4" type="text" id="Address04_Address2" value="${li.Address04_Address2}"/>
								<div class="col-span-1">City</div>
								<input class="col-span-1" placeholder="Memphis" type="text" id="Address04_City" value="${li.Address04_City}"/>
								<div class="col-span-1">State</div>
								<input class="col-span-1" placeholder="TN" type="text" id="Address04_State" value="${li.Address04_State}"/>
								<div class="col-span-1">Zip Code</div>
								<input class="col-span-1" placeholder="12345" type="text" id="Address04_ZipCode" value="${li.Address04_ZipCode}"/>
								<div class="col-span-1">Latitude</div>
								<input class="col-span-1" placeholder="1.2345" type="text" id="Address04_Lat" value="${li.Address04_Lat}"/>
								<div class="col-span-1">Longitude</div>
								<input class="col-span-1" placeholder="1.2345" type="text" id="Address04_Lng" value="${li.Address04_Lng}"/>
							</div>
							<div id="A5" class="col-span-1 grid grid-cols-2 gap-2">
								<div class="col-span-1">Street Number</div>
								<input class="col-span-1" placeholder="1234 Happy St." type="text" id="Address05_Address" value="${li.Address05_Address}"/>
								<div class="col-span-1">Street Number Cont.</div>
								<input class="col-span-1" placeholder="Apt # 4" type="text" id="Address05_Address2" value="${li.Address05_Address2}"/>
								<div class="col-span-1">City</div>
								<input class="col-span-1" placeholder="Memphis" type="text" id="Address05_City" value="${li.Address05_City}"/>
								<div class="col-span-1">State</div>
								<input class="col-span-1" placeholder="TN" type="text" id="Address05_State" value="${li.Address05_State}"/>
								<div class="col-span-1">Zip Code</div>
								<input class="col-span-1" placeholder="12345" type="text" id="Address05_ZipCode" value="${li.Address05_ZipCode}"/>
								<div class="col-span-1">Latitude</div>
								<input class="col-span-1" placeholder="1.2345" type="text" id="Address05_Lat" value="${li.Address05_Lat}"/>
								<div class="col-span-1">Longitude</div>
								<input class="col-span-1" placeholder="1.2345" type="text" id="Address05_Lng" value="${li.Address05_Lng}"/>
							</div>
							<div id="A6" class="col-span-1 grid grid-cols-2 gap-2">
								<div class="col-span-1">Street Number</div>
								<input class="col-span-1" placeholder="1234 Happy St." type="text" id="Address06_Address" value="${li.Address06_Address}"/>
								<div class="col-span-1">Street Number Cont.</div>
								<input class="col-span-1" placeholder="Apt # 4" type="text" id="Address06_Address2" value="${li.Address06_Address2}"/>
								<div class="col-span-1">City</div>
								<input class="col-span-1" placeholder="Memphis" type="text" id="Address06_City" value="${li.Address06_City}"/>
								<div class="col-span-1">State</div>
								<input class="col-span-1" placeholder="TN" type="text" id="Address06_State" value="${li.Address06_State}"/>
								<div class="col-span-1">Zip Code</div>
								<input class="col-span-1" placeholder="12345" type="text" id="Address06_ZipCode" value="${li.Address06_ZipCode}"/>
								<div class="col-span-1">Latitude</div>
								<input class="col-span-1" placeholder="1.2345" type="text" id="Address06_Lat" value="${li.Address06_Lat}"/>
								<div class="col-span-1">Longitude</div>
								<input class="col-span-1" placeholder="1.2345" type="text" id="Address06_Lng" value="${li.Address06_Lng}"/>
							</div>
							<div id="A7" class="col-span-1 grid grid-cols-2 gap-2">
								<div class="col-span-1">Street Number</div>
								<input class="col-span-1" placeholder="1234 Happy St." type="text" id="Address07_Address" value="${li.Address07_Address}"/>
								<div class="col-span-1">Street Number Cont.</div>
								<input class="col-span-1" placeholder="Apt # 4" type="text" id="Address07_Address2" value="${li.Address07_Address2}"/>
								<div class="col-span-1">City</div>
								<input class="col-span-1" placeholder="Memphis" type="text" id="Address07_City" value="${li.Address07_City}"/>
								<div class="col-span-1">State</div>
								<input class="col-span-1" placeholder="TN" type="text" id="Address07_State" value="${li.Address07_State}"/>
								<div class="col-span-1">Zip Code</div>
								<input class="col-span-1" placeholder="12345" type="text" id="Address07_ZipCode" value="${li.Address07_ZipCode}"/>
								<div class="col-span-1">Latitude</div>
								<input class="col-span-1" placeholder="1.2345" type="text" id="Address07_Lat" value="${li.Address07_Lat}"/>
								<div class="col-span-1">Longitude</div>
								<input class="col-span-1" placeholder="1.2345" type="text" id="Address07_Lng" value="${li.Address07_Lng}"/>
							</div>
							<div id="A8" class="col-span-1 grid grid-cols-2 gap-2">
								<div class="col-span-1">Street Number</div>
								<input class="col-span-1" placeholder="1234 Happy St." type="text" id="Address08_Address" value="${li.Address08_Address}"/>
								<div class="col-span-1">Street Number Cont.</div>
								<input class="col-span-1" placeholder="Apt # 4" type="text" id="Address08_Address2" value="${li.Address08_Address2}"/>
								<div class="col-span-1">City</div>
								<input class="col-span-1" placeholder="Memphis" type="text" id="Address08_City" value="${li.Address08_City}"/>
								<div class="col-span-1">State</div>
								<input class="col-span-1" placeholder="TN" type="text" id="Address08_State" value="${li.Address08_State}"/>
								<div class="col-span-1">Zip Code</div>
								<input class="col-span-1" placeholder="12345" type="text" id="Address08_ZipCode" value="${li.Address08_ZipCode}"/>
								<div class="col-span-1">Latitude</div>
								<input class="col-span-1" placeholder="1.2345" type="text" id="Address08_Lat" value="${li.Address08_Lat}"/>
								<div class="col-span-1">Longitude</div>
								<input class="col-span-1" placeholder="1.2345" type="text" id="Address08_Lng" value="${li.Address08_Lng}"/>
							</div>
						</div>
					</div>

					<div class="col-span-2">Projected Taxes Abated City</div>
					<div class="col-span-7 flex items-center">
						<span class="material-icons">attach_money</span>
						<input placeholder="0" type="text" id="ProjectedTaxesAbatedCity" value="${li.ProjectedTaxesAbatedCity}" />
					</div>

					<div class="col-span-2">Projected Taxes Abated County</div>
					<div class="col-span-7 flex items-center">
						<span class="material-icons">attach_money</span>
						<input placeholder="0" type="text" id="ProjectedTaxesAbatedCounty" value="${li.ProjectedTaxesAbatedCounty}" />
					</div>

					<div class="col-span-2">Date Approved</div>
					<div class="col-span-7">
						<input placeholder="0000-00-00 - Must Be This Format" type="text" id="DateApproved" value="${li.DateApproved}" />
					</div>

					<div class="col-span-2">Date Closed Real</div>
					<div class="col-span-7">
						<input placeholder="0000-00-00 - Must Be This Format" type="text" id="DateClosedRealProperty" value="${li.DateClosedRealProperty}" />
					</div>

					<div class="col-span-2">Date Closed Personal</div>
					<div class="col-span-7">
						<input placeholder="0000-00-00 - Must Be This Format" type="text" id="DateClosedPersonalProperty" value="${li.DateClosedPersonalProperty}" />
					</div>

					<div class="col-span-2">Date Closed Effective</div>
					<div class="col-span-7">
						<input placeholder="0000-00-00 - Must Be This Format" type="text" id="DateClosedEffectiveDate" value="${li.DateClosedEffectiveDate}" />
					</div>

					<div class="col-span-2">Lease Begins Real</div>
					<div class="col-span-7">
						<input placeholder="0000-00-00 - Must Be This Format" type="text" id="LeaseBeginsRealProperty"
						value="${li.LeaseBeginsRealProperty}" />
					</div>

					<div class="col-span-2">Lease Begins Personal</div>
					<div class="col-span-7">
						<input placeholder="0000-00-00 - Must Be This Format" type="text" id="LeaseBeginsPersonalProperty" value="${li.LeaseBeginsPersonalProperty}" />
					</div>

					<div class="col-span-2">Lease Expires Real</div>
					<div class="col-span-7">
						<input placeholder="0000-00-00 - Must Be This Format" type="text" id="LeaseExpiresRealProperty" value="${li.LeaseExpiresRealProperty}" />
					</div>

					<div class="col-span-2">Lease Expires Personal</div>
					<div class="col-span-7">
						<input placeholder="0000-00-00 - Must Be This Format" type="text" id="LeaseExpiresPersonalProperty" value="${li.LeaseExpiresPersonalProperty}" />
					</div>

					<div class="col-span-2">Date Amended</div>
					<div class="col-span-7 flex flex-col gap-2">
						<div class="flex items-center gap-4">
							<div>Amended 1</div>
							<input placeholder="0000-00-00 - Must Be This Format" type="text" id="DateAmended01" value="${li.DateAmended01}" />
						</div>
						<div class="flex items-center gap-4">
							<div>Amended 2</div>
							<input placeholder="0000-00-00 - Must Be This Format" type="text" id="DateAmended02" value="${li.DateAmended02}" />
						</div>
						<div class="flex items-center gap-4">
							<div>Amended 3</div>
							<input placeholder="0000-00-00 - Must Be This Format" type="text" id="DateAmended03" value="${li.DateAmended03}" />
						</div>
						<div class="flex items-center gap-4">
							<div>Amended 4</div>
							<input placeholder="0000-00-00 - Must Be This Format" type="text" id="DateAmended04" value="${li.DateAmended04}" />
						</div>
						<div class="flex items-center gap-4">
							<div>Amended 5</div>
							<input placeholder="0000-00-00 - Must Be This Format" type="text" id="DateAmended05" value="${li.DateAmended05}" />
						</div>
					</div>

					<div class="col-span-2">Ramp Up Period</div>
					<div class="col-span-7">
						<input placeholder="2 Years" type="text" id="RampUpPeriod" value="${li.RampUpPeriod}" />
					</div>

					<div class="col-span-2">Projected New Jobs</div>
					<div class="col-span-7">
						<input placeholder="123" type="text" id="ProjectedNewJobs" value="${li.ProjectedNewJobs}" />
					</div>

					<div class="col-span-2">Projected Retained Jobs</div>
					<div class="col-span-7">
						<input placeholder="123" type="text" id="ProjectedRetainedJobs" value="${li.ProjectedRetainedJobs}" />
					</div>

					<div class="col-span-2">Total Jobs</div>
					<div class="col-span-7">
						<input placeholder="123" type="text" id="TotalJobs" value="${li.TotalJobs}"/>
					</div>

					<div class="col-span-2">Projected Average Payroll Of New Jobs</div>
					<div class="col-span-7 flex items-center">
						<span class="material-icons">attach_money</span>
						<input placeholder="12345" type="text" id="ProjectedAveragePayrollOfNewJobs" value="${li.ProjectedAveragePayrollOfNewJobs}" />
					</div>

					<div class="col-span-2">Projected Average Payroll Of Retained Jobs</div>
					<div class="col-span-7 flex items-center">
						<span class="material-icons">attach_money</span>
						<input placeholder="12345" type="text" id="ProjectedAveragePayrollOfRetainedJobs" value="${li.ProjectedAveragePayrollOfRetainedJobs}" />
					</div>

					<div class="col-span-2">Total New Payroll</div>
					<div class="col-span-7 flex items-center">
						<span class="material-icons">attach_money</span>
						<input placeholder="12345" type="text" id="TotalNewPayroll" value="${li.TotalNewPayroll}" />
					</div>

					<div class="col-span-2">Total Retained Payroll</div>
					<div class="col-span-7 flex items-center">
						<span class="material-icons">attach_money</span>
						<input placeholder="12345" type="text" id="TotalRetainedPayroll" value="${li.TotalRetainedPayroll}" />
					</div>

					<div class="col-span-2">Employment Direct</div>
					<div class="col-span-7 flex items-center">
						<span class="material-icons">attach_money</span>
						<input placeholder="12345" type="text" id="EmploymentDirect" value="${li.EmploymentDirect}" />
					</div>

					<div class="col-span-2">Employment Indirect</div>
					<div class="col-span-7 flex items-center">
						<span class="material-icons">attach_money</span>
						<input placeholder="12345" type="text" id="EmploymentIndirect" value="${li.EmploymentIndirect}" />
					</div>

					<div class="col-span-2">Wages Direct</div>
					<div class="col-span-7 flex items-center">
						<span class="material-icons">attach_money</span>
						<input placeholder="12345" type="text" id="WagesDirect" value="${li.WagesDirect}" />
					</div>

					<div class="col-span-2">Wages Indirect</div>
					<div class="col-span-7 flex items-center">
						<span class="material-icons">attach_money</span>
						<input placeholder="12345" type="text" id="WagesIndirect" value="${li.WagesIndirect}" />
					</div>

					<div class="col-span-2">Projected MWBE/LOSB Spending</div>
					<div class="col-span-7 flex items-center">
						<span class="material-icons">attach_money</span>
						<input placeholder="12345" type="text" id="ProjectedMWBE_LOSBSpending" value="${li.ProjectedMWBE_LOSBSpending}" />
					</div>

					<div class="col-span-2">MWBE/LOSB Spending Construction</div>
					<div class="col-span-7 flex items-center">
						<span class="material-icons">attach_money</span>
						<input placeholder="12345" type="text" id="MWBE_LOSBSpendingConstruction" value="${li.MWBE_LOSBSpendingConstruction}" />
					</div>

					<div class="col-span-2">MWBE/LOSB Spending Operations</div>
					<div class="col-span-7 flex items-center">
						<span class="material-icons">attach_money</span>
						<input placeholder="12345" type="text" id="MWBE_LOSBSpendingOperations" value="${li.MWBE_LOSBSpendingOperations}" />
					</div>

					<div class="col-span-2">Community Reinvestment Credit</div>
					<div class="col-span-7 flex items-center">
						<span class="material-icons">attach_money</span>
						<input placeholder="12345" type="text" id="CommunityReinvestmentCredit" value="${li.CommunityReinvestmentCredit}" />
					</div>

					<div class="col-span-2">Real Property Investment</div>
					<div class="col-span-7 flex items-center">
						<span class="material-icons">attach_money</span>
						<input placeholder="12345" type="text" id="RealPropertyInvestment" value="${li.RealPropertyInvestment}" />
					</div>

					<div class="col-span-2">Personal Property Investment</div>
					<div class="col-span-7 flex items-center">
						<span class="material-icons">attach_money</span>
						<input placeholder="12345" type="text" id="PersonalPropertyInvestment" value="${li.PersonalPropertyInvestment}" />
					</div>

					<div class="col-span-2">Projected Capital Investment</div>
					<div class="col-span-7 flex items-center">
						<span class="material-icons">attach_money</span>
						<input placeholder="12345" type="text" id="ProjectedCapitalInvestment" value="${li.ProjectedCapitalInvestment}" />
					</div>

					<div class="col-span-2">Capital Investment Not In PILOT</div>
					<div class="col-span-7 flex items-center">
						<span class="material-icons">attach_money</span>
						<input placeholder="12345" type="text" id="CapitalInvestmentNotInPilot" value="${li.CapitalInvestmentNotInPilot}" />
					</div>

					<div class="col-span-2">Total Capital Investment</div>
					<div class="col-span-7 flex items-center">
						<span class="material-icons">attach_money</span>
						<input placeholder="12345" type="text" id="TotalCapitalInvestment" value="${li.TotalCapitalInvestment}" />
					</div>

					<div class="col-span-2">Total Incentive Provided</div>
					<div class="col-span-7 flex items-center">
						<span class="material-icons">attach_money</span>
						<input placeholder="12345" type="text" id="TotalIncentiveProvided" value="${li.TotalIncentiveProvided}" />
					</div>

					<div class="col-span-2">Total New Tax Revenues</div>
					<div class="col-span-7 flex items-center">
						<span class="material-icons">attach_money</span>
						<input placeholder="12345" type="text" id="TotalNewTaxRevenues" value="${li.TotalNewTaxRevenues}" />
					</div>

					<div class="col-span-2">Total Real Property Taxes Before</div>
					<div class="col-span-7 flex items-center">
						<span class="material-icons">attach_money</span>
						<input placeholder="12345" type="text" id="TotalRealPropertyTaxesBefore" value="${li.TotalRealPropertyTaxesBefore}" />
					</div>

					<div class="col-span-2">Total Personal Property Taxes Before</div>
					<div class="col-span-7 flex items-center">
						<span class="material-icons">attach_money</span>
						<input placeholder="12345" type="text" id="TotalPersonalPropertyTaxesBefore" value="${li.TotalPersonalPropertyTaxesBefore}" />
					</div>

					<div class="col-span-2">Total Real Property Taxes During</div>
					<div class="col-span-7 flex items-center">
						<span class="material-icons">attach_money</span>
						<input placeholder="12345" type="text" id="TotalRealPropertyTaxesDuring" value="${li.TotalRealPropertyTaxesDuring}" />
					</div>

					<div class="col-span-2">Total Personal Property Taxes During</div>
					<div class="col-span-7 flex items-center">
						<span class="material-icons">attach_money</span>
						<input placeholder="12345" type="text" id="TotalPersonalPropertyTaxesDuring" value="${li.TotalPersonalPropertyTaxesDuring}" />
					</div>

					<div class="col-span-2">Total Real Property Taxes After</div>
					<div class="col-span-7 flex items-center">
						<span class="material-icons">attach_money</span>
						<input placeholder="12345" type="text" id="TotalRealPropertyTaxesAfter" value="${li.TotalRealPropertyTaxesAfter}" />
					</div>

					<div class="col-span-2">Total Personal Property Taxes After</div>
					<div class="col-span-7 flex items-center">
						<span class="material-icons">attach_money</span>
						<input placeholder="12345" type="text" id="TotalPersonalPropertyTaxesAfter" value="${li.TotalPersonalPropertyTaxesAfter}" />
					</div>

					<div class="col-span-2">Benefit Cost Ratio</div>
					<div class="col-span-7">
						<input placeholder="0.0" type="text" id="BenefitCostRatio" value="${li.BenefitCostRatio}" />
					</div>

					<div class="col-span-2">City Council District</div>
					<div class="col-span-7">
						<select id="CityCouncilDistrict" />
							`;

				for (let i = 1; i <= 13; i++) {
					if (i == parseInt(li.CityCouncilDistrict)) {
						html += `<option value="${i}" selected>${i}</option>`;
					} else {
						html += `<option value="${i}">${i}</option>`;
					}
				}

				html += `</select>
					</div>

					<div class="col-span-2">City Council Super District</div>
					<div class="col-span-7">
						<select id="CityCouncilSuperDistrict" />
							`;

				for (let i = 1; i <= 13; i++) {
					if (i == parseInt(li.CityCouncilSuperDistrict)) {
						html += `<option value="${i}" selected>${i}</option>`;
					} else {
						html += `<option value="${i}">${i}</option>`;
					}
				}


				html += `</select>
					</div>

					<div class="col-span-2">County Commission District</div>
					<div class="col-span-7">
						<select id="CountyCommissionDistrict" />
							`;

				for (let i = 1; i <= 13; i++) {
					if (i == parseInt(li.CountyCommissionDistrict)) {
						html += `<option value="${i}" selected>${i}</option>`;
					} else {
						html += `<option value="${i}">${i}</option>`;
					}
				}


				html += `</select>
					</div>

					<div class="col-span-2">Additional Files Link</div>
					<div class="col-span-7">
						<input placeholder="File URL Here" type="text" id="FileLink" value="${li.FileLink}"  />
					</div>
					
				</div>
				`;

				html += `
					<div class="text-center">
						<button onclick="updateInDatabase()" id="update" class="py-2 px-8 font-bold bg-green-400 mt-8 rounded-md hover:bg-gray-400">Update</button>
					</div>
				`;
			} else if (current_list == "loans") {
				$('#list-data').html("");

				if (li.UseJobsInTotalJobCalculation == 1) {
					var _NC_Checked = "checked";
				} else {
					var _NC_Checked = "";
				}

				html += `
				<div class="text-xl font-bold mb-8 flex items-center justify-between">
				<div>Update Loan Form</div>
				<button class="bg-blue-300 hover:bg-gray-600 hover:text-white py-2 px-6 rounded-md" onclick="backToList()" id="back">Back</button>
				<button class="bg-red-300 hover:bg-gray-600 hover:text-white py-2 px-6 rounded-md" onclick="deleteConfirmation()" id="delete-confirm">Delete</button>
				</div>

				<div class="w-full grid grid-cols-9 gap-4">
					<div class="col-span-2">Company Name</div>
					<div class="col-span-7">
						<input placeholder="New Company Name" type="text" id="CompanyName" value="${li.CompanyName}" />
					</div>

					<div class="col-span-2">Project Number</div>
					<div class="col-span-7">
						<input placeholder="1234567890" type="text" id="ProjectNumber" value="${li.ProjectNumber}" />
					</div>

					<div class="col-span-2">Loan Use</div>
					<div class="col-span-7">
						<input placeholder="Loan Use" type="text" id="LoanUse" value="${li.LoanUse}" />
					</div>

					<div class="col-span-2">Project Type</div>
					<div class="col-span-7">
						<select id="ProjectType" />`;
				for (pt of LoanProjectTypes) {
					if (li.ProjectType == pt) {
						html += `<option value="${pt}" selected>${pt}</option>`;
					} else {
						html += `<option value="${pt}">${pt}</option>`;
					}
				}
				html += `</select>
					</div>

					<div class="col-span-2">Loan Type</div>
					<div class="col-span-7">
						<select placeholder="Loan Type" id="LoanType" />`;
				for (pt of LoanTypes) {
					if (li.LoanType == pt) {
						html += `<option value="${pt}" selected>${pt}</option>`;
					} else {
						html += `<option value="${pt}">${pt}</option>`;
					}
				}

				html += `</select>
					</div>

					<div class="col-span-2">Project Description</div>
					<div class="col-span-7">
						<textarea class="p-2 w-9/12" placeholder="Describe the project." id="ProjectDescription">${li.ProjectDescription}</textarea>
					</div>

					<div class="col-span-2">Term Length</div>
					<div class="col-span-7">
						<input placeholder="2 Years" type="text" id="Term" value="${li.Term}" />
					</div>

					<div class="col-span-2">Address</div>
					<div class="col-span-7 flex gap-4">
						<div id="A1" class="grid grid-cols-2 gap-2">
							<div class="col-span-1">Street Number</div>
							<input class="col-span-1" placeholder="1234 Happy St." type="text" id="Address" value="${li.Address}" />
							<div class="col-span-1">Street Number Cont.</div>
							<input class="col-span-1" placeholder="Apt # 4" type="text" id="Address2" value="${li.Address2}" />
							<div class="col-span-1">City</div>
							<input class="col-span-1" placeholder="Memphis" type="text" id="City" value="${li.City}" />
							<div class="col-span-1">State</div>
							<input class="col-span-1" placeholder="TN" type="text" id="State" value="${li.State}" />
							<div class="col-span-1">Zip Code</div>
							<input class="col-span-1" placeholder="12345" type="text" id="ZipCode" value="${li.ZipCode}" />
							<div class="col-span-1">Latitude</div>
							<input class="col-span-1" placeholder="1.2345" type="text" id="Lat" value="${li.Lat}" />
							<div class="col-span-1">Longitude</div>
							<input class="col-span-1" placeholder="1.2345" type="text" id="Lng" value="${li.Lng}" />
						</div>
					</div>

					<div class="col-span-2">Date Approved</div>
					<div class="col-span-7">
						<input placeholder="0000-00-00 - Must Be This Format" type="text" id="DateApproved" value="${li.DateApproved}" />
					</div>

					<div class="col-span-2">Date Closed</div>
					<div class="col-span-7">
						<input placeholder="0000-00-00 - Must Be This Format" type="text" id="DateClosed" value="${li.DateClosed}" />
					</div>

					<div class="col-span-2">Projected New Jobs</div>
					<div class="col-span-7">
						<input placeholder="123" type="text" id="ProjectedNewJobs" value="${li.ProjectedNewJobs}" />
					</div>

					<div class="col-span-2">Projected Retained Jobs</div>
					<div class="col-span-7">
						<input placeholder="123" type="text" id="ProjectedRetainedJobs" value="${li.ProjectedRetainedJobs}" />
					</div>

					<div class="col-span-2">Use Jobs In Total Job Calculation?</div>
					<div class="col-span-7">
						<input type="checkbox" id="UseJobsInTotalJobCalculation" ${_NC_Checked}/>
					</div>

					<div class="col-span-2">Average Payroll</div>
					<div class="col-span-7 flex items-center">
						<span class="material-icons">attach_money</span>
						<input placeholder="12345" type="text" id="AveragePayroll" value="${li.AveragePayroll}" />
					</div>

					<div class="col-span-2">Loan Amount</div>
					<div class="col-span-7 flex items-center">
						<span class="material-icons">attach_money</span>
						<input placeholder="12345" type="text" id="LoanAmount" value="${li.LoanAmount}" />
					</div>

					<div class="col-span-2">Interest Rate</div>
					<div class="col-span-7 flex items-center">
						<input placeholder="23" type="text" id="InterestRate" value="${li.InterestRate}" />
					</div>

					<div class="col-span-2">Total Projected Capital Investment</div>
					<div class="col-span-7 flex items-center">
						<span class="material-icons">attach_money</span>
						<input placeholder="12345" type="text" id="TotalProjectedCapitalInvestment" value="${li.TotalProjectedCapitalInvestment}" />
					</div>

					<div class="col-span-2">PCI: Real Property</div>
					<div class="col-span-7 flex items-center">
						<span class="material-icons">attach_money</span>
						<input placeholder="12345" type="text" id="PCI_RealProperty" value="${li.PCI_RealProperty}" />
					</div>

					<div class="col-span-2">PCI: Acquisition</div>
					<div class="col-span-7 flex items-center">
						<span class="material-icons">attach_money</span>
						<input placeholder="12345" type="text" id="PCI_Acquisition" value="${li.PCI_Acquisition}" />
					</div>

					<div class="col-span-2">PCI: Construction</div>
					<div class="col-span-7 flex items-center">
						<span class="material-icons">attach_money</span>
						<input placeholder="12345" type="text" id="PCI_Construction" value="${li.PCI_Construction}" />
					</div>

					<div class="col-span-2">PCI: Renovation</div>
					<div class="col-span-7 flex items-center">
						<span class="material-icons">attach_money</span>
						<input placeholder="12345" type="text" id="PCI_Renovation" value="${li.PCI_Renovation}" />
					</div>

					<div class="col-span-2">PCI: Machinery Equipment</div>
					<div class="col-span-7 flex items-center">
						<span class="material-icons">attach_money</span>
						<input placeholder="12345" type="text" id="PCI_MachineryEquipment" value="${li.PCI_MachineryEquipment}" />
					</div>

					<div class="col-span-2">PCI: Furniture/Fixtures/Office</div>
					<div class="col-span-7 flex items-center">
						<span class="material-icons">attach_money</span>
						<input placeholder="12345" type="text" id="PCI_FurnitureFixturesOffice" value="${li.PCI_FurnitureFixturesOffice}" />
					</div>

					<div class="col-span-2">PCI: Equipment</div>
					<div class="col-span-7 flex items-center">
						<span class="material-icons">attach_money</span>
						<input placeholder="12345" type="text" id="PCI_Equipment" value="${li.PCI_Equipment}" />
					</div>

					<div class="col-span-2">PCI: Fees/Soft/Costs</div>
					<div class="col-span-7 flex items-center">
						<span class="material-icons">attach_money</span>
						<input placeholder="12345" type="text" id="PCI_FeesSoftCosts" value="${li.PCI_FeesSoftCosts}" />
					</div>

					<div class="col-span-2">PCI: Permanent Working Capital</div>
					<div class="col-span-7 flex items-center">
						<span class="material-icons">attach_money</span>
						<input placeholder="12345" type="text" id="PCI_PermanentWorkingCapital" value="${li.PCI_PermanentWorkingCapital}" />
					</div>

					<div class="col-span-2">PCI: Miscellaneous</div>
					<div class="col-span-7 flex items-center">
						<span class="material-icons">attach_money</span>
						<input placeholder="12345" type="text" id="PCI_Miscellaneous" value="${li.PCI_Miscellaneous}" />
					</div>

					<div class="col-span-2">City Council District</div>
					<div class="col-span-7">
						<select id="CityCouncilDistrict" />
							`;

				for (let i = 1; i <= 13; i++) {
					if (i == parseInt(li.CityCouncilDistrict)) {
						html += `<option value="${i}" selected>${i}</option>`;
					} else {
						html += `<option value="${i}">${i}</option>`;
					}
				}

				html += `</select>
					</div>

					<div class="col-span-2">City Council Super District</div>
					<div class="col-span-7">
						<select id="CityCouncilSuperDistrict" />
							`;

				for (let i = 1; i <= 13; i++) {
					if (i == parseInt(li.CityCouncilSuperDistrict)) {
						html += `<option value="${i}" selected>${i}</option>`;
					} else {
						html += `<option value="${i}">${i}</option>`;
					}
				}

				html += `</select>
					</div>

					<div class="col-span-2">County Commission District</div>
					<div class="col-span-7">
						<select id="CountyCommissionDistrict" />
							`;

				for (let i = 1; i <= 13; i++) {
					if (i == parseInt(li.CountyCommissionDistrict)) {
						html += `<option value="${i}" selected>${i}</option>`;
					} else {
						html += `<option value="${i}">${i}</option>`;
					}
				}

				html += `</select>
					</div>

					<div class="col-span-2">Additional Files Link</div>
					<div class="col-span-7">
						<input placeholder="File URL Here" type="text" id="FileLink" value="${li.FileLink}"  />
					</div>
					
				</div>
				`;

				html += `
					<div class="text-center">
						<button onclick="updateInDatabase()" id="update" class="py-2 px-8 font-bold bg-green-400 mt-8 rounded-md hover:bg-gray-400">Update</button>
					</div>
				`;
			} else if (current_list == "others") {
				$('#list-data').html("");

				if (li.UseJobsInTotalJobCalculation == 1) {
					var _Jobs_Checked = "checked";
				} else {
					var _Jobs_Checked = "";
				}

				if (li.UseTotalInvestmentInTotalInvestmentCalculation == 1) {
					var _Investment_Checked = "checked";
				} else {
					var _Investment_Checked = "";
				}

				html += `
				<div class="text-xl font-bold mb-8 flex items-center justify-between">
				<div>Update Other Form</div>
				<button class="bg-blue-300 hover:bg-gray-600 hover:text-white py-2 px-6 rounded-md" onclick="backToList()" id="back">Back</button>
				<button class="bg-red-300 hover:bg-gray-600 hover:text-white py-2 px-6 rounded-md" onclick="deleteConfirmation()" id="delete-confirm">Delete</button>
				</div>

				<div class="w-full grid grid-cols-9 gap-4">
					<div class="col-span-2">Company Name</div>
					<div class="col-span-7">
						<input placeholder="New Company Name" type="text" id="CompanyName" value="${li.CompanyName}" />
					</div>

					<div class="col-span-2">Other Type</div>
					<div class="col-span-7">
						<select id="OtherType" />`;
				for (pt of OtherTypes) {
					if (li.OtherType == pt) {
						html += `<option value="${pt}" selected>${pt}</option>`;
					} else {
						html += `<option value="${pt}">${pt}</option>`;
					}
				}

				html += `</select>
					</div>

					<div class="col-span-2">Project Description</div>
					<div class="col-span-7">
						<textarea class="p-2 w-9/12" placeholder="Describe the project." id="ProjectDescription">${li.ProjectDescription}</textarea>
					</div>

					<div class="col-span-2">Term Length</div>
					<div class="col-span-7">
						<input placeholder="2 Years" type="text" id="BondTerm" value="${li.BondTerm}" />
					</div>

					<div class="col-span-2">Address</div>
					<div class="col-span-7 flex gap-4">
						<div id="A1" class="grid grid-cols-2 gap-2">
							<div class="col-span-1">Street Number</div>
							<input class="col-span-1" placeholder="1234 Happy St." type="text" id="Address" value="${li.Address}" />
							<div class="col-span-1">Street Number Cont.</div>
							<input class="col-span-1" placeholder="Apt # 4" type="text" id="Address2" value="${li.Address2}" />
							<div class="col-span-1">City</div>
							<input class="col-span-1" placeholder="Memphis" type="text" id="City" value="${li.City}" />
							<div class="col-span-1">County</div>
							<input class="col-span-1" placeholder="Shelby" type="text" id="County" value="${li.County}" />
							<div class="col-span-1">State</div>
							<input class="col-span-1" placeholder="TN" type="text" id="State" value="${li.State}" />
							<div class="col-span-1">Zip Code</div>
							<input class="col-span-1" placeholder="12345" type="text" id="ZipCode" value="${li.ZipCode}" />
							<div class="col-span-1">Latitude</div>
							<input class="col-span-1" placeholder="1.2345" type="text" id="Lat" value="${li.Lat}" />
							<div class="col-span-1">Longitude</div>
							<input class="col-span-1" placeholder="1.2345" type="text" id="Lng" value="${li.Lng}" />
						</div>
					</div>

					<div class="col-span-2">Date Approved</div>
					<div class="col-span-7">
						<input placeholder="0000-00-00 - Must Be This Format" type="text" id="DateApproved" value="${li.DateApproved}" />
					</div>

					<div class="col-span-2">Projected Total Jobs</div>
					<div class="col-span-7">
						<input placeholder="123" type="text" id="ProjectedTotalJobs" value="${li.ProjectedTotalJobs}" />
					</div>

					<div class="col-span-2">Use Jobs In Total Job Calculation?</div>
					<div class="col-span-7">
						<input type="checkbox" id="UseJobsInTotalJobCalculation" ${_Jobs_Checked}/>
					</div>

					<div class="col-span-2">Financing Amount</div>
					<div class="col-span-7 flex items-center">
						<span class="material-icons">attach_money</span>
						<input placeholder="12345" type="text" id="FinancingAmount" value="${li.FinancingAmount}" />
					</div>

					<div class="col-span-2">Total Investment</div>
					<div class="col-span-7 flex items-center">
						<span class="material-icons">attach_money</span>
						<input placeholder="12345" type="text" id="TotalInvestment" value="${li.TotalInvestment}" />
					</div>

					<div class="col-span-2">Use Total Investment In Total Investment Calculation?</div>
					<div class="col-span-7">
						<input type="checkbox" id="UseTotalInvestmentInTotalInvestmentCalculation" ${_Investment_Checked}/>
					</div>

					<div class="col-span-2">Calculation Type</div>
					<div class="col-span-7 flex items-center">
						<input placeholder="23" type="text" id="CalculationType" value="${li.CalculationType}" />
					</div>

					<div class="col-span-2">Value US</div>
					<div class="col-span-7 flex items-center">
						<span class="material-icons">attach_money</span>
						<input placeholder="12345" type="text" id="ValueUS" value="${li.ValueUS}" />
					</div>

					<div class="col-span-2">Exports</div>
					<div class="col-span-7 flex items-center">
						<span class="material-icons">attach_money</span>
						<input placeholder="12345" type="text" id="Exports" value="${li.Exports}" />
					</div>

					<div class="col-span-2">Total Shipments</div>
					<div class="col-span-7 flex items-center">
						<span class="material-icons">attach_money</span>
						<input placeholder="12345" type="text" id="TotalShipments" value="${li.TotalShipments}" />
					</div>

					<div class="col-span-2">Year</div>
					<div class="col-span-7 flex items-center">
						<span class="material-icons">attach_money</span>
						<input placeholder="12345" type="text" id="Year" value="${li.Year}" />
					</div>

					<div class="col-span-2">Additional File Link</div>
					<div class="col-span-7 flex items-center">
						<span class="material-icons">attach_money</span>
						<input placeholder="12345" type="text" id="FileLink" value="${li.FileLink}" />
					</div>
					`;

				html += `
					<div class="text-center">
						<button onclick="updateInDatabase()" id="update" class="py-2 px-8 font-bold bg-green-400 mt-8 rounded-md hover:bg-gray-400">Update</button>
					</div>
				`;
			} else if (current_list == "bonds") {
				$('#list-data').html("");

				if (li.UseJobsInTotalJobCalculation == 1) {
					var _Jobs_Checked = "checked";
				} else {
					var _Jobs_Checked = "";
				}

				if (li.UseTotalInvestmentInTotalInvestmentCalculation == 1) {
					var _Investment_Checked = "checked";
				} else {
					var _Investment_Checked = "";
				}

				if (li.UseBondAmountInTotalBondAmountCalculation == 1) {
					var _Bond_Checked = "checked";
				} else {
					var _Bond_Checked = "";
				}

				html += `
				<div class="text-xl font-bold mb-8 flex items-center justify-between">
				<div>Update Bond Form</div>
				<button class="bg-blue-300 hover:bg-gray-600 hover:text-white py-2 px-6 rounded-md" onclick="backToList()" id="back">Back</button>
				<button class="bg-red-300 hover:bg-gray-600 hover:text-white py-2 px-6 rounded-md" onclick="deleteConfirmation()" id="delete-confirm">Delete</button>
				</div>

				<div class="w-full grid grid-cols-9 gap-4">
					<div class="col-span-2">Company Name</div>
					<div class="col-span-7">
						<input placeholder="New Company Name" type="text" id="CompanyName" value="${li.CompanyName}" />
					</div>

					<div class="col-span-2">Project Description</div>
					<div class="col-span-7">
						<textarea class="p-2 w-9/12" placeholder="Describe the project." id="ProjectDescription">${li.ProjectDescription}</textarea>
					</div>

					<div class="col-span-2">Term Length</div>
					<div class="col-span-7">
						<input placeholder="2 Years" type="text" id="BondTerm" value="${li.BondTerm}" />
					</div>

					<div class="col-span-2">Address</div>
					<div class="col-span-7 flex gap-4">
						<div id="A1" class="grid grid-cols-2 gap-2">
							<div class="col-span-1">Street Number</div>
							<input class="col-span-1" placeholder="1234 Happy St." type="text" id="Address" value="${li.Address}" />
							<div class="col-span-1">Street Number Cont.</div>
							<input class="col-span-1" placeholder="Apt # 4" type="text" id="Address2" value="${li.Address2}" />
							<div class="col-span-1">City</div>
							<input class="col-span-1" placeholder="Memphis" type="text" id="City" value="${li.City}" />
							<div class="col-span-1">County</div>
							<input class="col-span-1" placeholder="Shelby" type="text" id="County" value="${li.County}" />
							<div class="col-span-1">State</div>
							<input class="col-span-1" placeholder="TN" type="text" id="State" value="${li.State}" />
							<div class="col-span-1">Zip Code</div>
							<input class="col-span-1" placeholder="12345" type="text" id="ZipCode" value="${li.ZipCode}" />
							<div class="col-span-1">Latitude</div>
							<input class="col-span-1" placeholder="1.2345" type="text" id="Lat" value="${li.Lat}" />
							<div class="col-span-1">Longitude</div>
							<input class="col-span-1" placeholder="1.2345" type="text" id="Lng" value="${li.Lng}" />
						</div>
					</div>

					<div class="col-span-2">Date Approved</div>
					<div class="col-span-7">
						<input placeholder="0000-00-00 - Must Be This Format" type="text" id="DateApproved" value="${li.DateApproved}" />
					</div>

					<div class="col-span-2">Projected Total Jobs</div>
					<div class="col-span-7">
						<input placeholder="123" type="text" id="ProjectedTotalJobs" value="${li.ProjectedTotalJobs}" />
					</div>

					<div class="col-span-2">Use Jobs In Total Job Calculation?</div>
					<div class="col-span-7">
						<input type="checkbox" id="UseJobsInTotalJobCalculation" ${_Jobs_Checked}/>
					</div>

					<div class="col-span-2">Bond Amount</div>
					<div class="col-span-7 flex items-center">
						<span class="material-icons">attach_money</span>
						<input placeholder="12345" type="text" id="BondAmount" value="${li.BondAmount}" />
					</div>

					<div class="col-span-2">Use Bond Amount In Total Bond Amount Calculation?</div>
					<div class="col-span-7">
						<input type="checkbox" id="UseBondAmountInTotalBondAmountCalculation" ${_Bond_Checked}/>
					</div>

					<div class="col-span-2">Total Investment</div>
					<div class="col-span-7 flex items-center">
						<span class="material-icons">attach_money</span>
						<input placeholder="12345" type="text" id="TotalInvestment" value="${li.TotalInvestment}" />
					</div>

					<div class="col-span-2">Use Total Investment In Total Investment Calculation?</div>
					<div class="col-span-7">
						<input type="checkbox" id="UseTotalInvestmentInTotalInvestmentCalculation" ${_Investment_Checked}/>
					</div>

					<div class="col-span-2">Area Coordinates</div>
					<div class="col-span-7">
						<textarea class="p-2 w-9/12" placeholder="[{a,b}, {c,d}...]" id="AreaCoordinates">${li.AreaCoordinates}</textarea>
					</div>

					<div class="col-span-2">Additional File Link</div>
					<div class="col-span-7 flex items-center">
						<span class="material-icons">attach_money</span>
						<input placeholder="12345" type="text" id="FileLink" value="${li.FileLink}" />
					</div>
					`;

				html += `
					<div class="text-center">
						<button onclick="updateInDatabase()" id="update" class="py-2 px-8 font-bold bg-green-400 mt-8 rounded-md hover:bg-gray-400">Update</button>
					</div>
				`;
			} else if (current_list == "tifs") {
				$('#list-data').html("");

				if (li.UseJobsInTotalJobCalculation == 1) {
					var _Jobs_Checked = "checked";
				} else {
					var _Jobs_Checked = "";
				}

				html += `
				<div class="text-xl font-bold mb-8 flex items-center justify-between">
				<div>Update TIF Form</div>
				<button class="bg-blue-300 hover:bg-gray-600 hover:text-white py-2 px-6 rounded-md" onclick="backToList()" id="back">Back</button>
				<button class="bg-red-300 hover:bg-gray-600 hover:text-white py-2 px-6 rounded-md" onclick="deleteConfirmation()" id="delete-confirm">Delete</button>
				</div>

				<div class="w-full grid grid-cols-9 gap-4">
					<div class="col-span-2">Company Name</div>
					<div class="col-span-7">
						<input placeholder="New Company Name" type="text" id="CompanyName" value="${li.CompanyName}" />
					</div>

					<div class="col-span-2">Project Description</div>
					<div class="col-span-7">
						<textarea class="p-2 w-9/12" placeholder="Describe the project." id="Summary">${li.Summary}</textarea>
					</div>

					<div class="col-span-2">Address</div>
					<div class="col-span-7 flex gap-4">
						<div id="A1" class="grid grid-cols-2 gap-2">
							<div class="col-span-1">Street Number</div>
							<input class="col-span-1" placeholder="1234 Happy St." type="text" id="Address" value="${li.Address}" />
							<div class="col-span-1">Street Number Cont.</div>
							<input class="col-span-1" placeholder="Apt # 4" type="text" id="Address2" value="${li.Address2}" />
							<div class="col-span-1">City</div>
							<input class="col-span-1" placeholder="Memphis" type="text" id="City" value="${li.City}" />
							<div class="col-span-1">County</div>
							<input class="col-span-1" placeholder="Shelby" type="text" id="County" value="${li.County}" />
							<div class="col-span-1">State</div>
							<input class="col-span-1" placeholder="TN" type="text" id="State" value="${li.State}" />
							<div class="col-span-1">Zip Code</div>
							<input class="col-span-1" placeholder="12345" type="text" id="ZipCode" value="${li.ZipCode}" />
							<div class="col-span-1">Latitude</div>
							<input class="col-span-1" placeholder="1.2345" type="text" id="Lat" value="${li.Lat}" />
							<div class="col-span-1">Longitude</div>
							<input class="col-span-1" placeholder="1.2345" type="text" id="Lng" value="${li.Lng}" />
						</div>
					</div>

					<div class="col-span-2">Date Approved</div>
					<div class="col-span-7">
						<input placeholder="0000-00-00 - Must Be This Format" type="text" id="DateApproved" value="${li.DateApproved}" />
					</div>

					<div class="col-span-2">Projected Total Jobs</div>
					<div class="col-span-7">
						<input placeholder="123" type="text" id="ProjectedTotalJobs" value="${li.ProjectedTotalJobs}" />
					</div>

					<div class="col-span-2">Use Jobs In Total Job Calculation?</div>
					<div class="col-span-7">
						<input type="checkbox" id="UseJobsInTotalJobCalculation" ${_Jobs_Checked}/>
					</div>

					<div class="col-span-2">TIF Amount</div>
					<div class="col-span-7 flex items-center">
						<span class="material-icons">attach_money</span>
						<input placeholder="12345" type="text" id="TIFAmount" value="${li.TIFAmount}" />
					</div>

					<div class="col-span-2">Total Investment</div>
					<div class="col-span-7 flex items-center">
						<span class="material-icons">attach_money</span>
						<input placeholder="12345" type="text" id="TotalInvestment" value="${li.TotalInvestment}" />
					</div>

					<div class="col-span-2">Projected MWBE Spending</div>
					<div class="col-span-7 flex items-center">
						<span class="material-icons">attach_money</span>
						<input placeholder="12345" type="text" id="ProjectedMWBESpending" value="${li.ProjectedMWBESpending}" />
					</div>

					<div class="col-span-2">Area Coordinates</div>
					<div class="col-span-7">
						<textarea class="p-2 w-9/12" placeholder="[{a,b}, {c,d}...]" id="AreaCoordinates">${li.AreaCoordinates}</textarea>
					</div>

					<div class="col-span-2">Additional File Link</div>
					<div class="col-span-7 flex items-center">
						<span class="material-icons">attach_money</span>
						<input placeholder="12345" type="text" id="FileLink" value="${li.FileLink}" />
					</div>
					`;

				html += `
					<div class="text-center">
						<button onclick="updateInDatabase()" id="update" class="py-2 px-8 font-bold bg-green-400 mt-8 rounded-md hover:bg-gray-400">Update</button>
					</div>
				`;
			}

			$('#content-display').html(html);
		};

		function clickedEntry(listing_name) {
			var open_list;
			editing = true;
			if (current_list == 'pilots') {
				open_list = pilots;
			}
			if (current_list == 'tifs') {
				open_list = tifs;
			}
			if (current_list == 'loans') {
				open_list = loans;
			}
			if (current_list == 'bonds') {
				open_list = bonds;
			}
			if (current_list == 'others') {
				open_list = others;
			}

			JSON.parse(open_list).forEach(function(o) {
				if (o.CompanyName == listing_name) {
					openListing(o);
				}
			});

		}

		function createNew() {
			let html = "";
			editing = true;
			if (current_list == "pilots") {
				$('#list-data').html("");

				html += `
				<div class="text-xl font-bold mb-8 flex items-center justify-between"><div>New PILOT Form</div>
				<button class="bg-blue-300 hover:bg-gray-600 hover:text-white py-2 px-6 rounded-md" onclick="backToList()" id="back">Back</button>
				</div>

				<div class="w-full grid grid-cols-9 gap-4">
					<div class="col-span-2">Company Name</div>
					<div class="col-span-7">
						<input placeholder="New Company Name" type="text" id="CompanyName" />
					</div>

					<div class="col-span-2">Project Number</div>
					<div class="col-span-7">
						<input placeholder="1234567890" type="text" id="ProjectNumber" />
					</div>

					<div class="col-span-2">Parcel ID</div>
					<div class="col-span-7">
						<input placeholder="1234_ABCD" type="text" id="ParcelID" />
					</div>

					<div class="col-span-2">Project Type</div>
					<div class="col-span-7">
						<select placeholder="Project Type" id="ProjectType" />`;
				for (pt of PilotProjectTypes) {
					html += `<option value="${pt}">${pt}</option>`;
				}
				html += `</select>
					</div>

					<div class="col-span-2">PILOT Type</div>
					<div class="col-span-7">
						<select placeholder="PILOT Type" id="PilotType" />`;
				for (pt of PilotTypes) {
					html += `<option value="${pt}">${pt}</option>`;
				}
				html += `</select>
					</div>

					<div class="col-span-2">PILOT Status</div>
					<div class="col-span-7">
						<select placeholder="PILOT Status" id="PilotStatus" />`;
				for (ps of PilotStatuses) {
					html += `<option value="${ps}">${ps}</option>`;
				}
				html += `</select>
					</div>

					<div class="col-span-2">Is New Construction?</div>
					<div class="col-span-7">
						<input type="checkbox" id="NewConstruction" />
					</div>

					<div class="col-span-2">Project Description</div>
					<div class="col-span-7">
						<textarea class="p-2" placeholder="Describe the project." id="ProjectDescription"></textarea>
					</div>

					<div class="col-span-2">Term Length</div>
					<div class="col-span-7">
						<input placeholder="2 Years" type="text" id="PilotTerm" />
					</div>

					<div class="col-span-2">Address</div>
					<div class="col-span-7 flex gap-4">
						<span id="AddressPlus" onclick="addAddress()" class="material-icons hover:text-gray-500 cursor-pointer pr-2">add_circle</span>
						<div class="grid grid-cols-1 sm:grid-cols-2 gap-x-4 gap-y-8">
							<div id="A1" class="col-span-1 grid grid-cols-2 gap-2">
								<div class="col-span-1">Street Number</div>
								<input class="col-span-1" placeholder="1234 Happy St." type="text" id="Address" />
								<div class="col-span-1">Street Number Cont.</div>
								<input class="col-span-1" placeholder="Apt # 4" type="text" id="Address2" />
								<div class="col-span-1">City</div>
								<input class="col-span-1" placeholder="Memphis" type="text" id="City" />
								<div class="col-span-1">State</div>
								<input class="col-span-1" placeholder="TN" type="text" id="State" />
								<div class="col-span-1">Zip Code</div>
								<input class="col-span-1" placeholder="12345" type="text" id="ZipCode" />
								<div class="col-span-1">Latitude</div>
								<input class="col-span-1" placeholder="1.2345" type="text" id="Lat" />
								<div class="col-span-1">Longitude</div>
								<input class="col-span-1" placeholder="1.2345" type="text" id="Lng" />
							</div>
							<div id="A2" class="col-span-1 grid grid-cols-2 gap-2 hidden">
								<div class="col-span-1">Street Number</div>
								<input class="col-span-1" placeholder="1234 Happy St." type="text" id="Address02_Address" />
								<div class="col-span-1">Street Number Cont.</div>
								<input class="col-span-1" placeholder="Apt # 4" type="text" id="Address02_Address2" />
								<div class="col-span-1">City</div>
								<input class="col-span-1" placeholder="Memphis" type="text" id="Address02_City" />
								<div class="col-span-1">State</div>
								<input class="col-span-1" placeholder="TN" type="text" id="Address02_State" />
								<div class="col-span-1">Zip Code</div>
								<input class="col-span-1" placeholder="12345" type="text" id="Address02_ZipCode" />
								<div class="col-span-1">Latitude</div>
								<input class="col-span-1" placeholder="1.2345" type="text" id="Address02_Lat" />
								<div class="col-span-1">Longitude</div>
								<input class="col-span-1" placeholder="1.2345" type="text" id="Address02_Lng" />
							</div>
							<div id="A3" class="col-span-1 grid grid-cols-2 gap-2 hidden">
								<div class="col-span-1">Street Number</div>
								<input class="col-span-1" placeholder="1234 Happy St." type="text" id="Address03_Address" />
								<div class="col-span-1">Street Number Cont.</div>
								<input class="col-span-1" placeholder="Apt # 4" type="text" id="Address03_Address2" />
								<div class="col-span-1">City</div>
								<input class="col-span-1" placeholder="Memphis" type="text" id="Address03_City" />
								<div class="col-span-1">State</div>
								<input class="col-span-1" placeholder="TN" type="text" id="Address03_State" />
								<div class="col-span-1">Zip Code</div>
								<input class="col-span-1" placeholder="12345" type="text" id="Address03_ZipCode" />
								<div class="col-span-1">Latitude</div>
								<input class="col-span-1" placeholder="1.2345" type="text" id="Address03_Lat" />
								<div class="col-span-1">Longitude</div>
								<input class="col-span-1" placeholder="1.2345" type="text" id="Address03_Lng" />
							</div>
							<div id="A4" class="col-span-1 grid grid-cols-2 gap-2 hidden">
								<div class="col-span-1">Street Number</div>
								<input class="col-span-1" placeholder="1234 Happy St." type="text" id="Address04_Address" />
								<div class="col-span-1">Street Number Cont.</div>
								<input class="col-span-1" placeholder="Apt # 4" type="text" id="Address04_Address2" />
								<div class="col-span-1">City</div>
								<input class="col-span-1" placeholder="Memphis" type="text" id="Address04_City" />
								<div class="col-span-1">State</div>
								<input class="col-span-1" placeholder="TN" type="text" id="Address04_State" />
								<div class="col-span-1">Zip Code</div>
								<input class="col-span-1" placeholder="12345" type="text" id="Address04_ZipCode" />
								<div class="col-span-1">Latitude</div>
								<input class="col-span-1" placeholder="1.2345" type="text" id="Address04_Lat" />
								<div class="col-span-1">Longitude</div>
								<input class="col-span-1" placeholder="1.2345" type="text" id="Address04_Lng" />
							</div>
							<div id="A5" class="col-span-1 grid grid-cols-2 gap-2 hidden">
								<div class="col-span-1">Street Number</div>
								<input class="col-span-1" placeholder="1234 Happy St." type="text" id="Address05_Address" />
								<div class="col-span-1">Street Number Cont.</div>
								<input class="col-span-1" placeholder="Apt # 4" type="text" id="Address05_Address2" />
								<div class="col-span-1">City</div>
								<input class="col-span-1" placeholder="Memphis" type="text" id="Address05_City" />
								<div class="col-span-1">State</div>
								<input class="col-span-1" placeholder="TN" type="text" id="Address05_State" />
								<div class="col-span-1">Zip Code</div>
								<input class="col-span-1" placeholder="12345" type="text" id="Address05_ZipCode" />
								<div class="col-span-1">Latitude</div>
								<input class="col-span-1" placeholder="1.2345" type="text" id="Address05_Lat" />
								<div class="col-span-1">Longitude</div>
								<input class="col-span-1" placeholder="1.2345" type="text" id="Address05_Lng" />
							</div>
							<div id="A6" class="col-span-1 grid grid-cols-2 gap-2 hidden">
								<div class="col-span-1">Street Number</div>
								<input class="col-span-1" placeholder="1234 Happy St." type="text" id="Address06_Address" />
								<div class="col-span-1">Street Number Cont.</div>
								<input class="col-span-1" placeholder="Apt # 4" type="text" id="Address06_Address2" />
								<div class="col-span-1">City</div>
								<input class="col-span-1" placeholder="Memphis" type="text" id="Address06_City" />
								<div class="col-span-1">State</div>
								<input class="col-span-1" placeholder="TN" type="text" id="Address06_State" />
								<div class="col-span-1">Zip Code</div>
								<input class="col-span-1" placeholder="12345" type="text" id="Address06_ZipCode" />
								<div class="col-span-1">Latitude</div>
								<input class="col-span-1" placeholder="1.2345" type="text" id="Address06_Lat" />
								<div class="col-span-1">Longitude</div>
								<input class="col-span-1" placeholder="1.2345" type="text" id="Address06_Lng" />
							</div>
							<div id="A7" class="col-span-1 grid grid-cols-2 gap-2 hidden">
								<div class="col-span-1">Street Number</div>
								<input class="col-span-1" placeholder="1234 Happy St." type="text" id="Address07_Address" />
								<div class="col-span-1">Street Number Cont.</div>
								<input class="col-span-1" placeholder="Apt # 4" type="text" id="Address07_Address2" />
								<div class="col-span-1">City</div>
								<input class="col-span-1" placeholder="Memphis" type="text" id="Address07_City" />
								<div class="col-span-1">State</div>
								<input class="col-span-1" placeholder="TN" type="text" id="Address07_State" />
								<div class="col-span-1">Zip Code</div>
								<input class="col-span-1" placeholder="12345" type="text" id="Address07_ZipCode" />
								<div class="col-span-1">Latitude</div>
								<input class="col-span-1" placeholder="1.2345" type="text" id="Address07_Lat" />
								<div class="col-span-1">Longitude</div>
								<input class="col-span-1" placeholder="1.2345" type="text" id="Address07_Lng" />
							</div>
							<div id="A8" class="col-span-1 grid grid-cols-2 gap-2 hidden">
								<div class="col-span-1">Street Number</div>
								<input class="col-span-1" placeholder="1234 Happy St." type="text" id="Address08_Address" />
								<div class="col-span-1">Street Number Cont.</div>
								<input class="col-span-1" placeholder="Apt # 4" type="text" id="Address08_Address2" />
								<div class="col-span-1">City</div>
								<input class="col-span-1" placeholder="Memphis" type="text" id="Address08_City" />
								<div class="col-span-1">State</div>
								<input class="col-span-1" placeholder="TN" type="text" id="Address08_State" />
								<div class="col-span-1">Zip Code</div>
								<input class="col-span-1" placeholder="12345" type="text" id="Address08_ZipCode" />
								<div class="col-span-1">Latitude</div>
								<input class="col-span-1" placeholder="1.2345" type="text" id="Address08_Lat" />
								<div class="col-span-1">Longitude</div>
								<input class="col-span-1" placeholder="1.2345" type="text" id="Address08_Lng" />
							</div>
						</div>
					</div>

					<div class="col-span-2">Projected Taxes Abated City</div>
					<div class="col-span-7 flex items-center">
						<span class="material-icons">attach_money</span>
						<input placeholder="0" type="text" id="ProjectedTaxesAbatedCity" />
					</div>

					<div class="col-span-2">Projected Taxes Abated County</div>
					<div class="col-span-7 flex items-center">
						<span class="material-icons">attach_money</span>
						<input placeholder="0" type="text" id="ProjectedTaxesAbatedCounty" />
					</div>

					<div class="col-span-2">Date Approved</div>
					<div class="col-span-7">
						<input placeholder="0000-00-00 - Must Be This Format" type="text" id="DateApproved" />
					</div>

					<div class="col-span-2">Date Closed Real</div>
					<div class="col-span-7">
						<input placeholder="0000-00-00 - Must Be This Format" type="text" id="DateClosedRealProperty" />
					</div>

					<div class="col-span-2">Date Closed Personal</div>
					<div class="col-span-7">
						<input placeholder="0000-00-00 - Must Be This Format" type="text" id="DateClosedPersonalProperty" />
					</div>

					<div class="col-span-2">Date Closed Effective</div>
					<div class="col-span-7">
						<input placeholder="0000-00-00 - Must Be This Format" type="text" id="DateClosedEffectiveDate" />
					</div>

					<div class="col-span-2">Lease Begins Real</div>
					<div class="col-span-7">
						<input placeholder="0000-00-00 - Must Be This Format" type="text" id="LeaseBeginsRealProperty" />
					</div>

					<div class="col-span-2">Lease Begins Personal</div>
					<div class="col-span-7">
						<input placeholder="0000-00-00 - Must Be This Format" type="text" id="LeaseBeginsPersonalProperty" />
					</div>

					<div class="col-span-2">Lease Expires Real</div>
					<div class="col-span-7">
						<input placeholder="0000-00-00 - Must Be This Format" type="text" id="LeaseExpiresRealProperty" />
					</div>

					<div class="col-span-2">Lease Expires Personal</div>
					<div class="col-span-7">
						<input placeholder="0000-00-00 - Must Be This Format" type="text" id="LeaseExpiresPersonalProperty" />
					</div>

					<div class="col-span-2">Ramp Up Period</div>
					<div class="col-span-7">
						<input placeholder="2 Years" type="text" id="RampUpPeriod" />
					</div>

					<div class="col-span-2">Projected New Jobs</div>
					<div class="col-span-7">
						<input placeholder="123" type="text" id="ProjectedNewJobs" />
					</div>

					<div class="col-span-2">Projected Retained Jobs</div>
					<div class="col-span-7">
						<input placeholder="123" type="text" id="ProjectedRetainedJobs" />
					</div>

					<div class="col-span-2">Total Jobs</div>
					<div class="col-span-7">
						<input placeholder="123" type="text" id="TotalJobs" />
					</div>

					<div class="col-span-2">Projected Average Payroll Of New Jobs</div>
					<div class="col-span-7 flex items-center">
						<span class="material-icons">attach_money</span>
						<input placeholder="12345" type="text" id="ProjectedAveragePayrollOfNewJobs" />
					</div>

					<div class="col-span-2">Projected Average Payroll Of Retained Jobs</div>
					<div class="col-span-7 flex items-center">
						<span class="material-icons">attach_money</span>
						<input placeholder="12345" type="text" id="ProjectedAveragePayrollOfRetainedJobs" />
					</div>

					<div class="col-span-2">Total New Payroll</div>
					<div class="col-span-7 flex items-center">
						<span class="material-icons">attach_money</span>
						<input placeholder="12345" type="text" id="TotalNewPayroll" />
					</div>

					<div class="col-span-2">Total Retained Payroll</div>
					<div class="col-span-7 flex items-center">
						<span class="material-icons">attach_money</span>
						<input placeholder="12345" type="text" id="TotalRetainedPayroll" />
					</div>

					<div class="col-span-2">Employment Direct</div>
					<div class="col-span-7 flex items-center">
						<span class="material-icons">attach_money</span>
						<input placeholder="12345" type="text" id="EmploymentDirect" />
					</div>

					<div class="col-span-2">Employment Indirect</div>
					<div class="col-span-7 flex items-center">
						<span class="material-icons">attach_money</span>
						<input placeholder="12345" type="text" id="EmploymentIndirect" />
					</div>

					<div class="col-span-2">Wages Direct</div>
					<div class="col-span-7 flex items-center">
						<span class="material-icons">attach_money</span>
						<input placeholder="12345" type="text" id="WagesDirect" />
					</div>

					<div class="col-span-2">Wages Indirect</div>
					<div class="col-span-7 flex items-center">
						<span class="material-icons">attach_money</span>
						<input placeholder="12345" type="text" id="WagesIndirect" />
					</div>

					<div class="col-span-2">Projected MWBE/LOSB Spending</div>
					<div class="col-span-7 flex items-center">
						<span class="material-icons">attach_money</span>
						<input placeholder="12345" type="text" id="ProjectedMWBE_LOSBSpending" />
					</div>

					<div class="col-span-2">MWBE/LOSB Spending Construction</div>
					<div class="col-span-7 flex items-center">
						<span class="material-icons">attach_money</span>
						<input placeholder="12345" type="text" id="MWBE_LOSBSpendingConstruction" />
					</div>

					<div class="col-span-2">MWBE/LOSB Spending Operations</div>
					<div class="col-span-7 flex items-center">
						<span class="material-icons">attach_money</span>
						<input placeholder="12345" type="text" id="MWBE_LOSBSpendingOperations" />
					</div>

					<div class="col-span-2">Community Reinvestment Credit</div>
					<div class="col-span-7 flex items-center">
						<span class="material-icons">attach_money</span>
						<input placeholder="12345" type="text" id="CommunityReinvestmentCredit" />
					</div>

					<div class="col-span-2">Real Property Investment</div>
					<div class="col-span-7 flex items-center">
						<span class="material-icons">attach_money</span>
						<input placeholder="12345" type="text" id="RealPropertyInvestment" />
					</div>

					<div class="col-span-2">Personal Property Investment</div>
					<div class="col-span-7 flex items-center">
						<span class="material-icons">attach_money</span>
						<input placeholder="12345" type="text" id="PersonalPropertyInvestment" />
					</div>

					<div class="col-span-2">Projected Capital Investment</div>
					<div class="col-span-7 flex items-center">
						<span class="material-icons">attach_money</span>
						<input placeholder="12345" type="text" id="ProjectedCapitalInvestment" />
					</div>

					<div class="col-span-2">Capital Investment Not In PILOT</div>
					<div class="col-span-7 flex items-center">
						<span class="material-icons">attach_money</span>
						<input placeholder="12345" type="text" id="CapitalInvestmentNotInPilot" />
					</div>

					<div class="col-span-2">Total Capital Investment</div>
					<div class="col-span-7 flex items-center">
						<span class="material-icons">attach_money</span>
						<input placeholder="12345" type="text" id="TotalCapitalInvestment" />
					</div>

					<div class="col-span-2">Total Incentive Provided</div>
					<div class="col-span-7 flex items-center">
						<span class="material-icons">attach_money</span>
						<input placeholder="12345" type="text" id="TotalIncentiveProvided" />
					</div>

					<div class="col-span-2">Total New Tax Revenues</div>
					<div class="col-span-7 flex items-center">
						<span class="material-icons">attach_money</span>
						<input placeholder="12345" type="text" id="TotalNewTaxRevenues" />
					</div>

					<div class="col-span-2">Total Real Property Taxes Before</div>
					<div class="col-span-7 flex items-center">
						<span class="material-icons">attach_money</span>
						<input placeholder="12345" type="text" id="TotalRealPropertyTaxesBefore" />
					</div>

					<div class="col-span-2">Total Personal Property Taxes Before</div>
					<div class="col-span-7 flex items-center">
						<span class="material-icons">attach_money</span>
						<input placeholder="12345" type="text" id="TotalPersonalPropertyTaxesBefore" />
					</div>

					<div class="col-span-2">Total Real Property Taxes During</div>
					<div class="col-span-7 flex items-center">
						<span class="material-icons">attach_money</span>
						<input placeholder="12345" type="text" id="TotalRealPropertyTaxesDuring" />
					</div>

					<div class="col-span-2">Total Personal Property Taxes During</div>
					<div class="col-span-7 flex items-center">
						<span class="material-icons">attach_money</span>
						<input placeholder="12345" type="text" id="TotalPersonalPropertyTaxesDuring" />
					</div>

					<div class="col-span-2">Total Real Property Taxes After</div>
					<div class="col-span-7 flex items-center">
						<span class="material-icons">attach_money</span>
						<input placeholder="12345" type="text" id="TotalRealPropertyTaxesAfter" />
					</div>

					<div class="col-span-2">Total Personal Property Taxes After</div>
					<div class="col-span-7 flex items-center">
						<span class="material-icons">attach_money</span>
						<input placeholder="12345" type="text" id="TotalPersonalPropertyTaxesAfter" />
					</div>

					<div class="col-span-2">Benefit Cost Ratio</div>
					<div class="col-span-7">
						<input placeholder="0.0" type="text" id="BenefitCostRatio" />
					</div>

					<div class="col-span-2">City Council District</div>
					<div class="col-span-7">
						<select id="CityCouncilDistrict" />
							<option value="1">1</option>
							<option value="2">2</option>
							<option value="3">3</option>
							<option value="4">4</option>
							<option value="5">5</option>
							<option value="6">6</option>
							<option value="7">7</option>
							<option value="8">8</option>
							<option value="9">9</option>
							<option value="10">10</option>
							<option value="11">11</option>
							<option value="12">12</option>
							<option value="13">13</option>
						</select>
					</div>

					<div class="col-span-2">City Council Super District</div>
					<div class="col-span-7">
						<select id="CityCouncilSuperDistrict" />
							<option value="1">1</option>
							<option value="2">2</option>
							<option value="3">3</option>
							<option value="4">4</option>
							<option value="5">5</option>
							<option value="6">6</option>
							<option value="7">7</option>
							<option value="8">8</option>
							<option value="9">9</option>
							<option value="10">10</option>
							<option value="11">11</option>
							<option value="12">12</option>
							<option value="13">13</option>
						</select>
					</div>

					<div class="col-span-2">County Commission District</div>
					<div class="col-span-7">
						<select id="CountyCommissionDistrict" />
							<option value="1">1</option>
							<option value="2">2</option>
							<option value="3">3</option>
							<option value="4">4</option>
							<option value="5">5</option>
							<option value="6">6</option>
							<option value="7">7</option>
							<option value="8">8</option>
							<option value="9">9</option>
							<option value="10">10</option>
							<option value="11">11</option>
							<option value="12">12</option>
							<option value="13">13</option>
						</select>
					</div>

					<div class="col-span-2">Additional Files Link</div>
					<div class="col-span-7">
						<input placeholder="File URL Here" type="text" id="FileLink" />
					</div>
					
				</div>
				`;

				html += `
					<div class="text-center">
						<button id="new-submit" class="py-2 px-8 font-bold bg-green-400 mt-8 rounded-md hover:bg-gray-400" onclick="addToDatabase()">Submit</button>
					</div>
				`;
			} else if (current_list == "loans") {
				$('#list-data').html("");

				html += `
				<div class="text-xl font-bold mb-8 flex items-center justify-between">
				<div>New Loan Form</div>
				<button class="bg-blue-300 hover:bg-gray-600 hover:text-white py-2 px-6 rounded-md" onclick="backToList()" id="back">Back</button>
				</div>

				<div class="w-full grid grid-cols-9 gap-4">
					<div class="col-span-2">Company Name</div>
					<div class="col-span-7">
						<input placeholder="New Company Name" type="text" id="CompanyName" value="" />
					</div>

					<div class="col-span-2">Project Number</div>
					<div class="col-span-7">
						<input placeholder="1234567890" type="text" id="ProjectNumber" value="" />
					</div>

					<div class="col-span-2">Loan Use</div>
					<div class="col-span-7">
						<input placeholder="Loan Use" type="text" id="LoanUse" value="" />
					</div>

					<div class="col-span-2">Project Type</div>
					<div class="col-span-7">
						<select id="ProjectType" />`;
				for (pt of LoanProjectTypes) {
					html += `<option value="${pt}">${pt}</option>`;
				}
				html += `</select>
					</div>

					<div class="col-span-2">Loan Type</div>
					<div class="col-span-7">
						<select placeholder="Loan Type" id="LoanType" />`;
				for (pt of LoanTypes) {
					html += `<option value="${pt}">${pt}</option>`;
				}

				html += `</select>
					</div>

					<div class="col-span-2">Project Description</div>
					<div class="col-span-7">
						<textarea class="p-2 w-9/12" placeholder="Describe the project." id="ProjectDescription"></textarea>
					</div>

					<div class="col-span-2">Term Length</div>
					<div class="col-span-7">
						<input placeholder="2 Years" type="text" id="Term" value="" />
					</div>

					<div class="col-span-2">Address</div>
					<div class="col-span-7 flex gap-4">
						<div id="A1" class="grid grid-cols-2 gap-2">
							<div class="col-span-1">Street Number</div>
							<input class="col-span-1" placeholder="1234 Happy St." type="text" id="Address" value="" />
							<div class="col-span-1">Street Number Cont.</div>
							<input class="col-span-1" placeholder="Apt # 4" type="text" id="Address2" value="" />
							<div class="col-span-1">City</div>
							<input class="col-span-1" placeholder="Memphis" type="text" id="City" value="" />
							<div class="col-span-1">State</div>
							<input class="col-span-1" placeholder="TN" type="text" id="State" value="" />
							<div class="col-span-1">Zip Code</div>
							<input class="col-span-1" placeholder="12345" type="text" id="ZipCode" value="" />
							<div class="col-span-1">Latitude</div>
							<input class="col-span-1" placeholder="1.2345" type="text" id="Lat" value="" />
							<div class="col-span-1">Longitude</div>
							<input class="col-span-1" placeholder="1.2345" type="text" id="Lng" value="" />
						</div>
					</div>

					<div class="col-span-2">Date Approved</div>
					<div class="col-span-7">
						<input placeholder="0000-00-00 - Must Be This Format" type="text" id="DateApproved" value="" />
					</div>

					<div class="col-span-2">Date Closed</div>
					<div class="col-span-7">
						<input placeholder="0000-00-00 - Must Be This Format" type="text" id="DateClosed" value="" />
					</div>

					<div class="col-span-2">Projected New Jobs</div>
					<div class="col-span-7">
						<input placeholder="123" type="text" id="ProjectedNewJobs" value="" />
					</div>

					<div class="col-span-2">Projected Retained Jobs</div>
					<div class="col-span-7">
						<input placeholder="123" type="text" id="ProjectedRetainedJobs" value="" />
					</div>

					<div class="col-span-2">Use Jobs In Total Job Calculation?</div>
					<div class="col-span-7">
						<input type="checkbox" id="UseJobsInTotalJobCalculation" checked/>
					</div>

					<div class="col-span-2">Average Payroll</div>
					<div class="col-span-7 flex items-center">
						<span class="material-icons">attach_money</span>
						<input placeholder="12345" type="text" id="AveragePayroll" value="" />
					</div>

					<div class="col-span-2">Loan Amount</div>
					<div class="col-span-7 flex items-center">
						<span class="material-icons">attach_money</span>
						<input placeholder="12345" type="text" id="LoanAmount" value="" />
					</div>

					<div class="col-span-2">Interest Rate</div>
					<div class="col-span-7 flex items-center">
						<input placeholder="23" type="text" id="InterestRate" value="" />
					</div>

					<div class="col-span-2">Total Projected Capital Investment</div>
					<div class="col-span-7 flex items-center">
						<span class="material-icons">attach_money</span>
						<input placeholder="12345" type="text" id="TotalProjectedCapitalInvestment" value="" />
					</div>

					<div class="col-span-2">PCI: Real Property</div>
					<div class="col-span-7 flex items-center">
						<span class="material-icons">attach_money</span>
						<input placeholder="12345" type="text" id="PCI_RealProperty" value="" />
					</div>

					<div class="col-span-2">PCI: Acquisition</div>
					<div class="col-span-7 flex items-center">
						<span class="material-icons">attach_money</span>
						<input placeholder="12345" type="text" id="PCI_Acquisition" value="" />
					</div>

					<div class="col-span-2">PCI: Construction</div>
					<div class="col-span-7 flex items-center">
						<span class="material-icons">attach_money</span>
						<input placeholder="12345" type="text" id="PCI_Construction" value="" />
					</div>

					<div class="col-span-2">PCI: Renovation</div>
					<div class="col-span-7 flex items-center">
						<span class="material-icons">attach_money</span>
						<input placeholder="12345" type="text" id="PCI_Renovation" value="" />
					</div>

					<div class="col-span-2">PCI: Machinery Equipment</div>
					<div class="col-span-7 flex items-center">
						<span class="material-icons">attach_money</span>
						<input placeholder="12345" type="text" id="PCI_MachineryEquipment" value="" />
					</div>

					<div class="col-span-2">PCI: Furniture/Fixtures/Office</div>
					<div class="col-span-7 flex items-center">
						<span class="material-icons">attach_money</span>
						<input placeholder="12345" type="text" id="PCI_FurnitureFixturesOffice" value="" />
					</div>

					<div class="col-span-2">PCI: Equipment</div>
					<div class="col-span-7 flex items-center">
						<span class="material-icons">attach_money</span>
						<input placeholder="12345" type="text" id="PCI_Equipment" value="" />
					</div>

					<div class="col-span-2">PCI: Fees/Soft/Costs</div>
					<div class="col-span-7 flex items-center">
						<span class="material-icons">attach_money</span>
						<input placeholder="12345" type="text" id="PCI_FeesSoftCosts" value="" />
					</div>

					<div class="col-span-2">PCI: Permanent Working Capital</div>
					<div class="col-span-7 flex items-center">
						<span class="material-icons">attach_money</span>
						<input placeholder="12345" type="text" id="PCI_PermanentWorkingCapital" value="" />
					</div>

					<div class="col-span-2">PCI: Miscellaneous</div>
					<div class="col-span-7 flex items-center">
						<span class="material-icons">attach_money</span>
						<input placeholder="12345" type="text" id="PCI_Miscellaneous" value="" />
					</div>

					<div class="col-span-2">City Council District</div>
					<div class="col-span-7">
						<select id="CityCouncilDistrict" />
							`;

				for (let i = 1; i <= 13; i++) {
					if (i == 1) {
						html += `<option value="${i}" selected>${i}</option>`;
					} else {
						html += `<option value="${i}">${i}</option>`;
					}
				}

				html += `</select>
					</div>

					<div class="col-span-2">City Council Super District</div>
					<div class="col-span-7">
						<select id="CityCouncilSuperDistrict" />
							`;

				for (let i = 1; i <= 13; i++) {
					if (i == 1) {
						html += `<option value="${i}" selected>${i}</option>`;
					} else {
						html += `<option value="${i}">${i}</option>`;
					}
				}

				html += `</select>
					</div>

					<div class="col-span-2">County Commission District</div>
					<div class="col-span-7">
						<select id="CountyCommissionDistrict" />
							`;

				for (let i = 1; i <= 13; i++) {
					if (i == 1) {
						html += `<option value="${i}" selected>${i}</option>`;
					} else {
						html += `<option value="${i}">${i}</option>`;
					}
				}

				html += `</select>
					</div>

					<div class="col-span-2">Additional Files Link</div>
					<div class="col-span-7">
						<input placeholder="File URL Here" type="text" id="FileLink" value=""  />
					</div>
					
				</div>
				`;

				html += `
					<div class="text-center">
						<button id="new-submit" class="py-2 px-8 font-bold bg-green-400 mt-8 rounded-md hover:bg-gray-400" onclick="addToDatabase()">Submit</button>
					</div>
				`;
			} else if (current_list == "others") {
				$('#list-data').html("");

				html += `
				<div class="text-xl font-bold mb-8 flex items-center justify-between">
				<div>New Other Form</div>
				<button class="bg-blue-300 hover:bg-gray-600 hover:text-white py-2 px-6 rounded-md" onclick="backToList()" id="back">Back</button>
				</div>

				<div class="w-full grid grid-cols-9 gap-4">
					<div class="col-span-2">Company Name</div>
					<div class="col-span-7">
						<input placeholder="New Company Name" type="text" id="CompanyName" value="" />
					</div>

					<div class="col-span-2">Other Type</div>
					<div class="col-span-7">
						<select id="OtherType" />`;
				for (pt of OtherTypes) {
					html += `<option value="${pt}">${pt}</option>`;
				}

				html += `</select>
					</div>

					<div class="col-span-2">Project Description</div>
					<div class="col-span-7">
						<textarea class="p-2 w-9/12" placeholder="Describe the project." id="ProjectDescription"></textarea>
					</div>

					<div class="col-span-2">Term Length</div>
					<div class="col-span-7">
						<input placeholder="2 Years" type="text" id="BondTerm" value="" />
					</div>

					<div class="col-span-2">Address</div>
					<div class="col-span-7 flex gap-4">
						<div id="A1" class="grid grid-cols-2 gap-2">
							<div class="col-span-1">Street Number</div>
							<input class="col-span-1" placeholder="1234 Happy St." type="text" id="Address" value="" />
							<div class="col-span-1">Street Number Cont.</div>
							<input class="col-span-1" placeholder="Apt # 4" type="text" id="Address2" value="" />
							<div class="col-span-1">City</div>
							<input class="col-span-1" placeholder="Memphis" type="text" id="City" value="" />
							<div class="col-span-1">County</div>
								<input class="col-span-1" placeholder="Shelby" type="text" id="County" value="" />
							<div class="col-span-1">State</div>
							<input class="col-span-1" placeholder="TN" type="text" id="State" value="" />
							<div class="col-span-1">Zip Code</div>
							<input class="col-span-1" placeholder="12345" type="text" id="ZipCode" value="" />
							<div class="col-span-1">Latitude</div>
							<input class="col-span-1" placeholder="1.2345" type="text" id="Lat" value="" />
							<div class="col-span-1">Longitude</div>
							<input class="col-span-1" placeholder="1.2345" type="text" id="Lng" value="" />
						</div>
					</div>

					<div class="col-span-2">Date Approved</div>
					<div class="col-span-7">
						<input placeholder="0000-00-00 - Must Be This Format" type="text" id="DateApproved" value="" />
					</div>

					<div class="col-span-2">Projected Total Jobs</div>
					<div class="col-span-7">
						<input placeholder="123" type="text" id="ProjectedTotalJobs" value="" />
					</div>

					<div class="col-span-2">Use Jobs In Total Job Calculation?</div>
					<div class="col-span-7">
						<input type="checkbox" id="UseJobsInTotalJobCalculation" checked/>
					</div>

					<div class="col-span-2">Financing Amount</div>
					<div class="col-span-7 flex items-center">
						<span class="material-icons">attach_money</span>
						<input placeholder="12345" type="text" id="FinancingAmount" value="" />
					</div>

					<div class="col-span-2">Total Investment</div>
					<div class="col-span-7 flex items-center">
						<span class="material-icons">attach_money</span>
						<input placeholder="12345" type="text" id="TotalInvestment" value="" />
					</div>

					<div class="col-span-2">Use Total Investment In Total Investment Calculation?</div>
					<div class="col-span-7">
						<input type="checkbox" id="UseTotalInvestmentInTotalInvestmentCalculation" checked/>
					</div>

					<div class="col-span-2">Calculation Type</div>
					<div class="col-span-7 flex items-center">
						<input placeholder="23" type="text" id="CalculationType" value="" />
					</div>

					<div class="col-span-2">Value US</div>
					<div class="col-span-7 flex items-center">
						<span class="material-icons">attach_money</span>
						<input placeholder="12345" type="text" id="ValueUS" value="" />
					</div>

					<div class="col-span-2">Exports</div>
					<div class="col-span-7 flex items-center">
						<span class="material-icons">attach_money</span>
						<input placeholder="12345" type="text" id="Exports" value="" />
					</div>

					<div class="col-span-2">Total Shipments</div>
					<div class="col-span-7 flex items-center">
						<span class="material-icons">attach_money</span>
						<input placeholder="12345" type="text" id="TotalShipments" value="" />
					</div>

					<div class="col-span-2">Year</div>
					<div class="col-span-7 flex items-center">
						<span class="material-icons">attach_money</span>
						<input placeholder="12345" type="text" id="Year" value="" />
					</div>

					<div class="col-span-2">Additional File Link</div>
					<div class="col-span-7 flex items-center">
						<span class="material-icons">attach_money</span>
						<input placeholder="12345" type="text" id="FileLink" value="" />
					</div>
					`;

				html += `
					<div class="text-center">
						<button id="new-submit" class="py-2 px-8 font-bold bg-green-400 mt-8 rounded-md hover:bg-gray-400" onclick="addToDatabase()">Submit</button>
					</div>
				`;
			} else if (current_list == "bonds") {
				$('#list-data').html("");

				html += `
				<div class="text-xl font-bold mb-8 flex items-center justify-between">
				<div>New Bond Form</div>
				<button class="bg-blue-300 hover:bg-gray-600 hover:text-white py-2 px-6 rounded-md" onclick="backToList()" id="back">Back</button>
				</div>

				<div class="w-full grid grid-cols-9 gap-4">
					<div class="col-span-2">Company Name</div>
					<div class="col-span-7">
						<input placeholder="New Company Name" type="text" id="CompanyName" value="" />
					</div>

					<div class="col-span-2">Project Description</div>
					<div class="col-span-7">
						<textarea class="p-2 w-9/12" placeholder="Describe the project." id="ProjectDescription"></textarea>
					</div>

					<div class="col-span-2">Term Length</div>
					<div class="col-span-7">
						<input placeholder="2 Years" type="text" id="BondTerm" value="" />
					</div>

					<div class="col-span-2">Address</div>
					<div class="col-span-7 flex gap-4">
						<div id="A1" class="grid grid-cols-2 gap-2">
							<div class="col-span-1">Street Number</div>
							<input class="col-span-1" placeholder="1234 Happy St." type="text" id="Address" value="" />
							<div class="col-span-1">Street Number Cont.</div>
							<input class="col-span-1" placeholder="Apt # 4" type="text" id="Address2" value="" />
							<div class="col-span-1">City</div>
							<input class="col-span-1" placeholder="Memphis" type="text" id="City" value="" />
							<div class="col-span-1">County</div>
							<input class="col-span-1" placeholder="Shelby" type="text" id="County" value="" />
							<div class="col-span-1">State</div>
							<input class="col-span-1" placeholder="TN" type="text" id="State" value="" />
							<div class="col-span-1">Zip Code</div>
							<input class="col-span-1" placeholder="12345" type="text" id="ZipCode" value="" />
							<div class="col-span-1">Latitude</div>
							<input class="col-span-1" placeholder="1.2345" type="text" id="Lat" value="" />
							<div class="col-span-1">Longitude</div>
							<input class="col-span-1" placeholder="1.2345" type="text" id="Lng" value="" />
						</div>
					</div>

					<div class="col-span-2">Date Approved</div>
					<div class="col-span-7">
						<input placeholder="0000-00-00 - Must Be This Format" type="text" id="DateApproved" value="" />
					</div>

					<div class="col-span-2">Projected Total Jobs</div>
					<div class="col-span-7">
						<input placeholder="123" type="text" id="ProjectedTotalJobs" value="" />
					</div>

					<div class="col-span-2">Use Jobs In Total Job Calculation?</div>
					<div class="col-span-7">
						<input type="checkbox" id="UseJobsInTotalJobCalculation" checked/>
					</div>

					<div class="col-span-2">Bond Amount</div>
					<div class="col-span-7 flex items-center">
						<span class="material-icons">attach_money</span>
						<input placeholder="12345" type="text" id="BondAmount" value="" />
					</div>

					<div class="col-span-2">Use Bond Amount In Total Bond Amount Calculation?</div>
					<div class="col-span-7">
						<input type="checkbox" id="UseBondAmountInTotalBondAmountCalculation" checked/>
					</div>

					<div class="col-span-2">Total Investment</div>
					<div class="col-span-7 flex items-center">
						<span class="material-icons">attach_money</span>
						<input placeholder="12345" type="text" id="TotalInvestment" value="" />
					</div>

					<div class="col-span-2">Use Total Investment In Total Investment Calculation?</div>
					<div class="col-span-7">
						<input type="checkbox" id="UseTotalInvestmentInTotalInvestmentCalculation" checked/>
					</div>

					<div class="col-span-2">Area Coordinates</div>
					<div class="col-span-7">
						<textarea class="p-2 w-9/12" placeholder="[{a,b}, {c,d}...]" id="AreaCoordinates"></textarea>
					</div>

					<div class="col-span-2">Additional File Link</div>
					<div class="col-span-7 flex items-center">
						<span class="material-icons">attach_money</span>
						<input placeholder="12345" type="text" id="FileLink" value="" />
					</div>
					`;

				html += `
					<div class="text-center">
						<button id="new-submit" class="py-2 px-8 font-bold bg-green-400 mt-8 rounded-md hover:bg-gray-400" onclick="addToDatabase()">Submit</button>
					</div>
				`;
			} else if (current_list == "tifs") {
				$('#list-data').html("");

				html += `
				<div class="text-xl font-bold mb-8 flex items-center justify-between">
				<div>New TIF Form</div>
				<button class="bg-blue-300 hover:bg-gray-600 hover:text-white py-2 px-6 rounded-md" onclick="backToList()" id="back">Back</button>
				</div>

				<div class="w-full grid grid-cols-9 gap-4">
					<div class="col-span-2">Company Name</div>
					<div class="col-span-7">
						<input placeholder="New Company Name" type="text" id="CompanyName" value="" />
					</div>

					<div class="col-span-2">Project Description</div>
					<div class="col-span-7">
						<textarea class="p-2 w-9/12" placeholder="Describe the project." id="Summary"></textarea>
					</div>

					<div class="col-span-2">Address</div>
					<div class="col-span-7 flex gap-4">
						<div id="A1" class="grid grid-cols-2 gap-2">
							<div class="col-span-1">Street Number</div>
							<input class="col-span-1" placeholder="1234 Happy St." type="text" id="Address" value="" />
							<div class="col-span-1">Street Number Cont.</div>
							<input class="col-span-1" placeholder="Apt # 4" type="text" id="Address2" value="" />
							<div class="col-span-1">City</div>
							<input class="col-span-1" placeholder="Memphis" type="text" id="City" value="" />
							<div class="col-span-1">County</div>
							<input class="col-span-1" placeholder="Shelby" type="text" id="County" value="" />
							<div class="col-span-1">State</div>
							<input class="col-span-1" placeholder="TN" type="text" id="State" value="" />
							<div class="col-span-1">Zip Code</div>
							<input class="col-span-1" placeholder="12345" type="text" id="ZipCode" value="" />
							<div class="col-span-1">Latitude</div>
							<input class="col-span-1" placeholder="1.2345" type="text" id="Lat" value="" />
							<div class="col-span-1">Longitude</div>
							<input class="col-span-1" placeholder="1.2345" type="text" id="Lng" value="" />
						</div>
					</div>

					<div class="col-span-2">Date Approved</div>
					<div class="col-span-7">
						<input placeholder="0000-00-00 - Must Be This Format" type="text" id="DateApproved" value="" />
					</div>

					<div class="col-span-2">Projected Total Jobs</div>
					<div class="col-span-7">
						<input placeholder="123" type="text" id="ProjectedTotalJobs" value="" />
					</div>

					<div class="col-span-2">Use Jobs In Total Job Calculation?</div>
					<div class="col-span-7">
						<input type="checkbox" id="UseJobsInTotalJobCalculation" checked/>
					</div>

					<div class="col-span-2">TIF Amount</div>
					<div class="col-span-7 flex items-center">
						<span class="material-icons">attach_money</span>
						<input placeholder="12345" type="text" id="TIFAmount" value="" />
					</div>

					<div class="col-span-2">Total Investment</div>
					<div class="col-span-7 flex items-center">
						<span class="material-icons">attach_money</span>
						<input placeholder="12345" type="text" id="TotalInvestment" value="" />
					</div>

					<div class="col-span-2">Projected MWBE Spending</div>
					<div class="col-span-7 flex items-center">
						<span class="material-icons">attach_money</span>
						<input placeholder="12345" type="text" id="ProjectedMWBESpending" value="" />
					</div>

					<div class="col-span-2">Area Coordinates</div>
					<div class="col-span-7">
						<textarea class="p-2 w-9/12" placeholder="[{a,b}, {c,d}...]" id="AreaCoordinates"></textarea>
					</div>

					<div class="col-span-2">Additional File Link</div>
					<div class="col-span-7 flex items-center">
						<span class="material-icons">attach_money</span>
						<input placeholder="12345" type="text" id="FileLink" value="" />
					</div>
					`;

				html += `
					<div class="text-center">
						<button id="new-submit" class="py-2 px-8 font-bold bg-green-400 mt-8 rounded-md hover:bg-gray-400" onclick="addToDatabase()">Submit</button>
					</div>
				`;
			}

			$('#content-display').html(html);
		};

		function set_up_data(list) {
			editing = false;
			let html = `
				<div onclick="createNew()" class="col-span-1 bg-red-900 text-white  p-4 text-lg">
					+ Create New
				</div>
			`;

			JSON.parse(list).sort((a, b) => {
				if (a.CompanyName && b.CompanyName) {
					return a.CompanyName.localeCompare(b.CompanyName);
				}
			}).forEach((p) => {
				if (p || p.CompanyName) {
					html += `
				<div onclick="clickedEntry('${p.CompanyName}')" class="listing-name col-span-1 bg-gray-300 p-4 text-lg">
					${p.CompanyName}
				</div>
			`;
				}
			});

			$('#list-data').html(html);
		}

		function addAddress() {
			pilot_address_count++;
			console.log(pilot_address_count);
			$("#A" + pilot_address_count).removeClass("hidden");
		}

		$(document).ready(function() {
			set_up_data(pilots);

			$("#list-menu>div").click(function() {
				$(this).css("color", "rgba(138, 31, 3, 1)");
				$(this).siblings().css("color", "rgba(204, 204, 204, 1)");

				$("#content-display").html("");

				if ($(this).html() == "Pilots") {
					current_list = "pilots";
					if (editing) {
						var r = confirm("Are you sure you want to leave this page? You will lose any unsaved changes.");
						if (r == true) {
							set_up_data(pilots);
						}
					} else {
						set_up_data(pilots);
					}
				} else if ($(this).html() == "TIFs") {
					current_list = "tifs";
					if (editing) {
						var r = confirm("Are you sure you want to leave this page? You will lose any unsaved changes.");
						if (r == true) {
							set_up_data(tifs);
						}
					} else {
						set_up_data(tifs);
					}
				} else if ($(this).html() == "Loans") {
					current_list = "loans";
					if (editing) {
						var r = confirm("Are you sure you want to leave this page? You will lose any unsaved changes.");
						if (r == true) {
							set_up_data(loans);
						}
					} else {
						set_up_data(loans);
					}
				} else if ($(this).html() == "Bonds") {
					current_list = "bonds";
					if (editing) {
						var r = confirm("Are you sure you want to leave this page? You will lose any unsaved changes.");
						if (r == true) {
							set_up_data(bonds);
						}
					} else {
						set_up_data(bonds);
					}
				} else if ($(this).html() == "Others") {
					current_list = "others";
					if (editing) {
						var r = confirm("Are you sure you want to leave this page? You will lose any unsaved changes.");
						if (r == true) {
							set_up_data(others);
						}
					} else {
						set_up_data(others);
					}
				}
			});
		});
	</script>

	<div id="list-menu" class="w-full flex flex-row gap-8 text-2xl font-semibold my-6">
		<div>Pilots</div>
		<div>TIFs</div>
		<div>Loans</div>
		<div>Bonds</div>
		<div>Others</div>
	</div>

	<div id="list-content">
		<div id="list-data" class="grid grid-cols-1 sm:grid-cols-2 md:grid-cols-3 gap-2">Loading...</div>
	</div>

	<div id="content-display" class=""></div>


	<script>
		$(document).ready(function() {
			$('#wp-admin-bar-top-secondary').html(
				`<li><a href="<?php echo wp_logout_url(); ?>" class="ab-item">Log Out</a></li>`
			);
		});
	</script>

<?php
	// Ends here from top
}


/**
 * Currently plugin version.
 * Start at version 1.0.0 and use SemVer - https://semver.org
 * Rename this for your plugin and update it as you release new versions.
 */
define('PLUGIN_NAME_VERSION', '1.0.0');

/**
 * The code that runs during plugin activation.
 * This action is documented in includes/class-plugin-name-activator.php
 */
function activate_plugin_name()
{
	require_once plugin_dir_path(__FILE__) . 'includes/class-plugin-name-activator.php';
	Plugin_Name_Activator::activate();
}

/**
 * The code that runs during plugin deactivation.
 * This action is documented in includes/class-plugin-name-deactivator.php
 */
function deactivate_plugin_name()
{
	require_once plugin_dir_path(__FILE__) . 'includes/class-plugin-name-deactivator.php';
	Plugin_Name_Deactivator::deactivate();
}

register_activation_hook(__FILE__, 'activate_plugin_name');
register_deactivation_hook(__FILE__, 'deactivate_plugin_name');

/**
 * The core plugin class that is used to define internationalization,
 * admin-specific hooks, and public-facing site hooks.
 */
require plugin_dir_path(__FILE__) . 'includes/class-plugin-name.php';

/**
 * Begins execution of the plugin.
 *
 * Since everything within the plugin is registered via hooks,
 * then kicking off the plugin from this point in the file does
 * not affect the page life cycle.
 *
 * @since    1.0.0
 */
function run_plugin_name()
{

	$plugin = new PLUGIN_NAME();
	$plugin->run();
}
run_plugin_name();
